/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.io;

import com.sun.messaging.jmq.io.VRFileMap;
import com.sun.messaging.jmq.io.VRecord;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;

public class VRecordMap
extends VRecord {
    private static boolean DEBUG = Boolean.getBoolean("vrfile.debug");
    private VRFileMap vrfile;
    private ByteBuffer bbuf;
    private ByteBuffer databuf;
    private MappedByteBuffer parent;

    VRecordMap(VRFileMap vRFileMap, MappedByteBuffer mappedByteBuffer, ByteBuffer byteBuffer) {
        this.vrfile = vRFileMap;
        this.parent = mappedByteBuffer;
        this.bbuf = byteBuffer;
        this.magic = this.bbuf.getInt();
        this.capacity = this.bbuf.getInt();
        this.state = this.bbuf.getShort();
        this.cookie = this.bbuf.getShort();
        this.bbuf.limit(this.capacity);
        this.bbuf.position(12);
        this.databuf = this.bbuf.slice();
    }

    VRecordMap(VRFileMap vRFileMap, MappedByteBuffer mappedByteBuffer, ByteBuffer byteBuffer, int n) {
        this.vrfile = vRFileMap;
        this.parent = mappedByteBuffer;
        this.bbuf = byteBuffer;
        this.capacity = n;
        this.state = (short)2;
        this.bbuf.putInt(this.magic);
        this.bbuf.putInt(this.capacity);
        this.bbuf.putShort(this.state);
        this.bbuf.putShort(this.cookie);
        this.bbuf.limit(this.capacity);
        this.bbuf.position(12);
        this.databuf = this.bbuf.slice();
    }

    public ByteBuffer getBuffer() {
        return this.databuf;
    }

    public void force() throws IOException {
        if (DEBUG) {
            System.out.println("will do force on " + this.parent);
        }
        this.parent.force();
    }

    public void setCookie(short s) throws IOException {
        this.cookie = s;
        this.bbuf.putShort(10, this.cookie);
        if (this.vrfile.getSafe()) {
            this.force();
        }
    }

    public short getCookie() {
        return this.cookie;
    }

    public String toString() {
        return "VRecordMap: " + this.bbuf.toString();
    }

    MappedByteBuffer getParent() {
        return this.parent;
    }

    void free() {
        this.state = 1;
        this.bbuf.putShort(8, this.state);
        this.bbuf.putShort(10, (short)0);
        this.databuf.rewind();
    }

    void allocate(short s) {
        this.state = s;
        this.bbuf.putShort(8, this.state);
    }
}

