/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsclient.validation;

import com.sun.messaging.jmq.jmsclient.Debug;
import com.sun.messaging.jmq.jmsclient.ExceptionHandler;
import com.sun.messaging.jmq.jmsclient.validation.ErrorHandler;
import com.sun.messaging.jmq.jmsclient.validation.EventHandler;
import java.io.IOException;
import java.io.StringReader;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.jms.JMSException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLValidator {
    public static final String IS_Validate = "imq.xml.schema.validate";
    public static final String XSD_URI_LIST = "imq.xml.schema.uri";
    private Vector urilist = null;
    private String xsdURIList = null;
    private Schema schema = null;
    private Validator validator = null;
    private StreamSource[] ssarray = null;
    private boolean reloadXSDOnFailure = false;
    private String schemaLanguage = "http://www.w3.org/2001/XMLSchema";
    private SAXParser saxParser = null;
    private EventHandler eventHandler = null;
    private boolean debug = Debug.debug;

    protected XMLValidator() throws JMSException {
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setValidating(true);
            this.saxParser = sAXParserFactory.newSAXParser();
            this.eventHandler = new EventHandler();
        }
        catch (Exception exception) {
            com.sun.messaging.jms.JMSException jMSException = new com.sun.messaging.jms.JMSException(exception.getMessage());
            ((JMSException)jMSException).setLinkedException(exception);
            ExceptionHandler.throwJMSException(jMSException);
        }
    }

    protected XMLValidator(String string) throws JMSException {
        this("http://www.w3.org/2001/XMLSchema", string);
    }

    protected XMLValidator(String string, String string2) throws JMSException {
        try {
            this.xsdURIList = string2;
            if (string2 == null) {
                throw new NullPointerException("XSD URI List can not be null");
            }
            this.urilist = new Vector();
            StringTokenizer stringTokenizer = new StringTokenizer(string2, " ");
            while (stringTokenizer.hasMoreElements()) {
                String string3 = stringTokenizer.nextToken();
                this.urilist.add(string3);
            }
            if (string != null) {
                this.setSchemaLanguage(string);
            }
            this.initSchema();
        }
        catch (Exception exception) {
            com.sun.messaging.jms.JMSException jMSException = new com.sun.messaging.jms.JMSException(exception.getMessage());
            ((JMSException)jMSException).setLinkedException(exception);
            ExceptionHandler.throwJMSException(jMSException);
        }
    }

    private synchronized void initStreamSource() {
        int n = this.urilist.size();
        this.ssarray = new StreamSource[n];
        for (int i = 0; i < n; ++i) {
            String string = (String)this.urilist.elementAt(i);
            this.ssarray[i] = new StreamSource(string);
        }
    }

    private synchronized void setSchemaLanguage(String string) {
        this.schemaLanguage = string;
    }

    private synchronized void initSchema() throws SAXException {
        this.initStreamSource();
        SchemaFactory schemaFactory = SchemaFactory.newInstance(this.schemaLanguage);
        this.schema = schemaFactory.newSchema(this.ssarray);
        this.validator = this.schema.newValidator();
        ErrorHandler errorHandler = new ErrorHandler();
        this.validator.setErrorHandler(errorHandler);
    }

    public synchronized void validate(String string) throws JMSException {
        try {
            if (this.validator != null) {
                if (this.reloadXSDOnFailure) {
                    this.reloadXMLSchemaOnFailure(string);
                } else {
                    this.doValidateXSD(string);
                }
            } else if (this.saxParser != null) {
                StringReader stringReader = new StringReader(string);
                InputSource inputSource = new InputSource(stringReader);
                this.saxParser.parse(inputSource, (DefaultHandler)this.eventHandler);
                this.saxParser.reset();
            }
        }
        catch (Exception exception) {
            com.sun.messaging.jms.JMSException jMSException = new com.sun.messaging.jms.JMSException(exception.getMessage());
            ((JMSException)jMSException).setLinkedException(exception);
            ExceptionHandler.throwJMSException(jMSException);
        }
    }

    private synchronized void reloadXMLSchemaOnFailure(String string) throws SAXException, IOException {
        if (this.debug) {
            Debug.println("*** In reloadXMLSchemaOnFailure, validating xml ... ");
        }
        try {
            this.doValidateXSD(string);
        }
        catch (Exception exception) {
            if (this.debug) {
                Debug.println("*** reloading XSD from " + this.xsdURIList);
            }
            this.initSchema();
            if (this.debug) {
                Debug.println("*** re-validating XML ..." + string);
            }
            this.doValidateXSD(string);
        }
    }

    private synchronized void doValidateXSD(String string) throws SAXException, IOException {
        StringReader stringReader = new StringReader(string);
        InputSource inputSource = new InputSource(stringReader);
        SAXSource sAXSource = new SAXSource(inputSource);
        this.validator.validate(sAXSource);
    }

    public synchronized void validateURI(String string) throws JMSException {
        try {
            if (this.validator != null) {
                StreamResult streamResult = new StreamResult(System.out);
                StreamSource streamSource = new StreamSource(string);
                this.validator.validate(streamSource, streamResult);
            } else if (this.saxParser != null) {
                System.out.println("*** use saxParser .... isValidating: " + this.saxParser.isValidating());
                this.saxParser.parse(string, (DefaultHandler)this.eventHandler);
            }
        }
        catch (Exception exception) {
            com.sun.messaging.jms.JMSException jMSException = new com.sun.messaging.jms.JMSException(exception.getMessage());
            ((JMSException)jMSException).setLinkedException(exception);
            ExceptionHandler.throwJMSException(jMSException);
        }
    }

    public String getURIList() {
        return this.xsdURIList;
    }

    public synchronized void setReloadOnFailure(boolean bl) {
        this.reloadXSDOnFailure = bl;
    }

    public boolean getReloadOnFailure() {
        return this.reloadXSDOnFailure;
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length == 2) {
            XMLValidator xMLValidator = new XMLValidator(stringArray[0]);
            xMLValidator.validateURI(stringArray[1]);
            System.out.println("xml is validated: " + stringArray[1]);
        } else {
            XMLValidator xMLValidator = new XMLValidator();
            xMLValidator.validateURI(stringArray[0]);
            System.out.println("xml is validated without schema: " + stringArray[0]);
        }
    }
}

