/*
######################################################################
# xs_encode.c - This is PyukiWiki yet another Wiki clone
# $Id: xs_encode.c,v 1.103 2013/03/30 21:24:28 papu Exp $
# Build 2013-03-27 07:44:07
#
# 
# Author Nanami
# http://nanakochi.daiba.cx/
# Copyright(C) 2004-2007 Nekyo
# Copyright(C) 2005-2013 PyukiWiki Developers Team
# http://pyukiwiki.info/
# Based on YukiWiki http://www.hyuki.com/yukiwiki/
# Powerd by PukiWiki http://pukiwiki.sfjp.jp/
# License GPL3 and/or Artistic or each later version
#
# This program is free software; you can redistribute it and/or
# modify it under the same terms as Perl itself.
# Return=CRLF Code=UTF-8 1TAB=4Spaces
######################################################################
*/

#include "../xslib/xslib.h"

#define	hexc(c)	((((c) < 10) ? ((c) + '0') : ((c) + 'W')))

char	*xs_encode(char *dst, char *src) {
	char	*save = dst;
	register	char	c;

	for(; c = *src++;) {
		if(c == 0x20) {
			*dst++ = '+';
		} else if(c <= 0x2f) {
			*dst++ = '%';
			*dst++ = hexc((c) / 16);
			*dst++ = hexc((c) % 16);
		} else if(c <= 0x39) {
			*dst++ = c;
		} else if(c <= 0x40) {
			*dst++ = '%';
			*dst++ = hexc((c) / 16);
			*dst++ = hexc((c) % 16);
		} else if(c <= 0x5a || c == 0x5f) {
			*dst++ = c;
		} else if(c <= 0x60) {
			*dst++ = '%';
			*dst++ = hexc((c) / 16);
			*dst++ = hexc((c) % 16);
		} else if(c <= 0x7a) {
			*dst++ = c;
		} else {
			*dst++ = '%';
			*dst++ = hexc((c) / 16);
			*dst++ = hexc((c) % 16);
		}
	}
	*dst='\0';
	return save;
}
