######################################################################
# ad_extra.inc.pl - This is PyukiWiki yet another Wiki clone
# $Id: ad_extra.inc.pl,v 1.3 2013/03/30 21:24:20 papu Exp $
# Build 2013-03-30 09:34:32
#
# "ad" ver 1.10 $$
# Author Nanami http://nanakochi.daiba.cx/
# Copyright(C) 2004-2007 Nekyo
# Copyright(C) 2005-2013 PyukiWiki Developers Team
# http://pyukiwiki.info/
# Based on YukiWiki http://www.hyuki.com/yukiwiki/
# Powerd by PukiWiki http://pukiwiki.sfjp.jp/
# License GPL3 and/or Artistic or each later version
#
# This program is free software; you can redistribute it and/or
# modify it under the same terms as Perl itself.
# Return=CRLF Code=UTF-8 1TAB=4Spaces
######################################################################

$PLUGIN="ad";
$VERSION="1.10";

require "$::plugin_dir/ad.inc.pl";

sub plugin_ad_extra_before {
	my($view)=@_;
	my $ad=&plugin_ad_view("_" . $view);
	if($ad ne "") {
		return <<EOM;
<div class="ad_$view\_pre">
EOM
	} else {
		return " ";
	}
}

sub plugin_ad_extra_after {
	my($view)=@_;
	my $ad=&plugin_ad_view("_" . $view);
	if($ad ne "") {
		return <<EOM;
</div>
EOM
	} else {
		return " ";
	}
}

sub plugin_ad_extra_main {
	my($view)=@_;
	my $ad=&plugin_ad_view("_" . $view);
	if($ad ne "") {
		return <<EOM;
<div class="ad_$view">
$ad
</div>
EOM
	} else {
		return " ";
	}
}

sub plugin_ad_extra_last {
	my($view)=@_;
	my $ad=&plugin_ad_view("_" . $view);
	if($ad ne "") {
		return <<EOM;
<div class="ad_$view\_last">
</div>
EOM
	} else {
		return " ";
	}
}

1;
__END__

=head1 NAME

ad_edit.inc.pl - PyukiWiki Administrator's Plugin

=head1 SYNOPSIS

This is ad.inc.pl's sub plugin, Look ad.inc.pl's perl pod

=head1 SEE ALSO

=over 4

=item PyukiWiki/Plugin/Nanami/ad/

L<http://pyukiwiki.info/PyukiWiki/Plugin/Nanami/ad/>

=item PyukiWiki CVS

L<http://sfjp.jp/cvs/view/pyukiwiki/PyukiWiki-Devel/plugin/ad.inc.pl?view=log>

L<http://sfjp.jp/cvs/view/pyukiwiki/PyukiWiki-Devel-UTF8/plugin/ad.inc.pl?view=log>

L<http://cvs.pyukiwiki.info/cgi-bin/cvsweb.cgi/PyukiWiki-Devel/plugin/ad.inc.pl?view=log>

L<http://cvs.pyukiwiki.info/cgi-bin/cvsweb.cgi/PyukiWiki-Devel-UTF8/plugin/ad.inc.pl?view=log>

L<http://sfjp.jp/cvs/view/pyukiwiki/PyukiWiki-Devel/plugin/ad_edit.inc.pl?view=log>

L<http://sfjp.jp/cvs/view/pyukiwiki/PyukiWiki-Devel-UTF8/plugin/ad_edit.inc.pl?view=log>

L<http://cvs.pyukiwiki.info/cgi-bin/cvsweb.cgi/PyukiWiki-Devel/plugin/ad_edit.inc.pl?view=log>

L<http://cvs.pyukiwiki.info/cgi-bin/cvsweb.cgi/PyukiWiki-Devel-UTF8/plugin/ad_edit.inc.pl?view=log>

=back

=head1 AUTHOR

=over 4

=item Nanami

L<http://nanakochi.daiba.cx/> etc...

=item PyukiWiki Developers Team

L<http://pyukiwiki.info/>

=back

=head1 LICENSE

Copyright(C) 2005-2013 by Nanami.

Copyright(C) 2005-2013 by PyukiWiki Developers Team

License is GNU GENERAL PUBLIC LICENSE 3 and/or Artistic 1 or each later version.

This program is free software; you can redistribute it and/or
modify it under the same terms as Perl itself.

=cut
