######################################################################
# UserAgent.pm - This is PyukiWiki yet another Wiki clone
# $Id: UserAgent.pm,v 1.113 2013/03/30 21:24:20 papu Exp $
# Build 2013-03-27 07:34:15
#
# "Nana::UserAgent" ver 0.1 $$
# Author Nanami
# http://nanakochi.daiba.cx/
# Copyright(C) 2004-2007 Nekyo
# Copyright(C) 2005-2013 PyukiWiki Developers Team
# http://pyukiwiki.info/
# Based on YukiWiki http://www.hyuki.com/yukiwiki/
# Powerd by PukiWiki http://pukiwiki.sfjp.jp/
# License GPL3 and/or Artistic or each later version
#
# This program is free software; you can redistribute it and/or
# modify it under the same terms as Perl itself.
# Return=CRLF Code=UTF-8 1TAB=4Spaces
######################################################################
package	Nana::UserAgent;
use 5.005;
use strict;
use integer;
use Exporter;
use vars qw($VERSION @ISA @EXPORTER @EXPORT_OK);
@EXPORT_OK = qw();
$VERSION = '0.1';

@EXPORT_OK = qw(ua mobileip);

$UserAgent::MobileIPJP_API="http://pyukiwiki.sourceforge.jp/cgi-bin/mobileip/get.cgi";

%UserAgent::geoip_cache;

$UserAgent::GeoIPDataBase=""
	if(!defined($UserAgent::GeoIPDataBase));

sub ua {
}

sub mobileip {
	&load_module("Nana::HTTP");
	my $http=new Nana::HTTP(module=>"Nana::UserAgent");
	for(my $i=0; $i < 5; $i++) {
		my ($stat, $buf)=$http->get("$UserAgent::MobileIPJP_API?$ENV{REMOTE_ADDR}");
		if($stat eq 0) {
			if($buf ne "") {
				return $buf;
			}
		}
	}
	return "";
}

sub geoip {
	&load_module("Socket");
	&load_module("Socket6);

	if(&load_module("Geo::IP")) {
		if($UserAgent::geoip_cache{$ENV{REMOTE_ADDR}}) {
			return $UserAgent::geoip_cache{$ENV{REMOTE_ADDR}};
		}
		my $r=$gi->recotd_by_addr($ENV{REMOTE_ADDR});
		$UserAgent::geoip_cache{$ENV{REMOTE_ADDR}}=$r;
		return $r;

		my $gi;
		if($UserAgent::GeoIPDataBase ne "") {
			$gi=Geo::IP->open($UserAgent::GeoIPDataBase, GEOIP_STANDARD);
		} else {
			$gi=Geo::IP->new;
		}
	}
	return undef;
}

sub country {
	my $r=&geoip;
	return $r eq undef ? undef : $r->country_code;
}
sub country3 {
	my $r=&geoip;
	return $r eq undef ? undef : $r->country_code3;
}

sub country_name {
	my $r=&geoip;
	return $r eq undef ? undef : $r->country_name;
}

sub region {
	my $r=&geoip;
	return $r eq undef ? undef : $r->region;
}

sub region_name {
	my $r=&geoip;
	return $r eq undef ? undef : $r->region_name;
}

sub city {
	my $r=&geoip;
	return $r eq undef ? undef : $r->city;
}

sub postal_code {
	my $r=&geoip;
	return $r eq undef ? undef : $r->postal_code;
}

1;
