######################################################################
# html.inc.pl - This is PyukiWiki, yet another Wiki clone.
# $Id: html.inc.pl,v 1.1 2012/02/27 20:14:50 papu Exp $
#
# "html" version 1.0 $$
# Author: Nanami http://nanakochi.daiba.cx/
# Copyright (C) 2004-2012 Nekyo
# http://nekyo.qp.land.to/
# Copyright (C) 2005-2012 PyukiWiki Developers Team
# http://pyukiwiki.sfjp.jp/
# Based on YukiWiki http://www.hyuki.com/yukiwiki/
# Powerd by PukiWiki http://pukiwiki.sfjp.jp/
# License: GPL3 and/or Artistic or each later version
#
# This program is free software; you can redistribute it and/or
# modify it under the same terms as Perl itself.
# Return:LF Code=EUC-JP 1TAB=4Spaces
######################################################################

$PLUGIN="html";
$VERSION="1.0";

sub plugin_html_convert {
	my ($eom)=@_;
	return ' ' if(!&is_frozen($::form{mypage}));
	$::linedata="";
	$::linesave=1;
	$::eom_string=$eom;
	$::eom_string="#html" if($eom eq '');
	$::exec_inlinefunc=\&plugin_html_display;
	return ' '
}

sub plugin_html_display {
	my($text)=@_;
	return ' ' if(!&is_frozen($::form{mypage}));
	return $text;
}

1;
__END__
=head1 NAME

html.inc.pl - PyukiWiki Plugin

=head1 SYNOPSIS

 #html(EOM)
 <font size="7">BIG FONT</font>
 EOM

=head1 DESCRIPTION

Display HTML

=head1 SEE ALSO

=over 4

=item PyukiWiki/Plugin/Nanami/sh

L<http://pyukiwiki.sfjp.jp/PyukiWiki/Plugin/Nanami/html/>

=item PyukiWiki CVS

L<http://sfjp.jp/cvs/view/pyukiwiki/PyukiWiki-Devel/plugin/html.inc.pl?view=log>

L<http://sfjp.jp/cvs/view/pyukiwiki/PyukiWiki-Devel-UTF8/plugin/html.inc.pl?view=log>

=back

=head1 AUTHOR

=over 4

=item Nanami

L<http://nanakochi.daiba.cx/> etc...

=item PyukiWiki Developers Team

L<http://pyukiwiki.sfjp.jp/>

=back

=head1 LICENSE

Copyright (C) 2005-2012 by Nanami.

Copyright (C) 2005-2012 by PyukiWiki Developers Team

License is GNU GENERAL PUBLIC LICENSE 3 and/or Artistic 1 or each later version.

This program is free software; you can redistribute it and/or
modify it under the same terms as Perl itself.

=cut
