######################################################################
# playvideo.inc.pl - This is PyukiWiki, yet another Wiki clone.
# $Id: playvideo.inc.pl,v 1.103 2012/03/01 07:55:22 papu Exp $
#
# "playvideo" version 2.2a $$
# Author: Nanami http://nanakochi.daiba.cx/
# Copyright (C) 2004-2012 Nekyo
# http://nekyo.qp.land.to/
# Copyright (C) 2005-2012 PyukiWiki Developers Team
# http://pyukiwiki.sfjp.jp/
# Based on YukiWiki http://www.hyuki.com/yukiwiki/
# Powerd by PukiWiki http://pukiwiki.sfjp.jp/
# License: GPL3 and/or Artistic or each later version
#
# This program is free software; you can redistribute it and/or
# modify it under the same terms as Perl itself.
# Return:LF Code=EUC-JP 1TAB=4Spaces
######################################################################
# 2012/02/18 change: WMVʤƤMP4аư褦ˤ
#                    ΰ١åץɻ MP4::Infoɬפˤʤޤ
#                    IEǤΥݥåץåפ򳫤Τ٤Τ
# 2012/02/14 change: ̥ɥ򳫤ʤƤФ⡼ɤ֤ʦǡ
# 2012/02/13 change: JavaScriptݥåץåפǥɥѹ褦
#                    
#                    video.js2.0.23.0.7˥С󥢥åפ
# 2011/10/07 change: ʣΥȤư褬ʬƤƤбǤ褦ˤ
#                    wmvPyukiWikiƱȤ֤ʤ
#                    ޤ󤬡mp4flv̥Ȥ֤뤳Ȥ
#                    Ǥ褦ˤʤä
#                    ΥСˤˤϡdeletecache 򤹤ɬפꡢ
#                    ġFLVMP4եõ硢⤦ deletecache
#                    򤹤ɬפޤ
#                    ̵zipʳˤ⡢WMVեɤǤ
#                    褦ˤʥǥեȤ̵zip
# 2011/10/05 change: HEADꥯȤѤơWMVʳγĥҤư
#                    PyukiWiki֤Ƥ륵СʳǤ褦
#                    ޤIE 9 ˤơvideo.js̵
# 2011/10/02 change: HTML5ץ쥤䡼бΰ١HTML5֥饦Ǥʤ
#                    FlashǺˡMP4ե뤬ɬפˤʤ롣
#                    λѴեޥåȤϡFlowPlayerǧ褦
#                    MPEG4 AVC/H.264ѴʤФʤʤ
#                    FlashǤκ⥵ݡȤƤޤIE10
#                    ǥȥåǰʳǥݡȤʤʤ뤿ᡢߴΰ٤
#                    ϤƤޤ
#                    IE9ԶǡIE9ˤƤϡHTML5ץ쥤䡼ϻ
#                    Ǥʤ褦ˤʤäƤޤ
# 2011/09/11 change: ǥեȤΥɤ߹褦ˤ
#                    FireFoxǥˤưΥɤΤ˻ߤ
#                    ꤷƤɤǽϤǤ褦ˤ
# 2011/06/12 change: flvưˤбwmvɬפǤ
# 2011/05/26 change: wmv˥դƤ硢zipեΥ
#                    ե̾򤽤̾˻Ǥ褦ˤ
# 2011/05/26 change: info/setup.cgiб
# 2011/03/14 change: Content-disposition: attachment; filename="$file.wvx"
#                    Ϥ꤬ǽ뤿ᡢϤ
#                    
# 2011/03/01 change: ĥҤwvxѹ
#                    Content-Type: video/x-ms-wvx Ϥ
#                    Content-disposition: attachment; filename="$file.wvx"
#                    Ϥ
# 2010/12/10 change: ˥˥ưб
# 2010/11/13 change: ̵zipǥɤǤ褦ˤ
#                    ̤ư褬Ȥå夫褦
#                    ͭ¤ϣ֤Ǥ
# 2010/10/27 change: MSIE OperaʳWindwos Mediaץ쥤䡼
#                    _blank(¼̥֡ˤˤʤ褦ˤ
#                    SafariǤˤʤޤ
# 2010/10/24 change: use sub make_link_target
######################################################################
# Usage:
# &playvideo(name, [options...]);
# #playvideo(name, [options...])
#
#  name : video file name
#    if not place filename extention, new window open.
#    if place filename extention (wmv or html)
#      inner window player
#
#  options :
#    image=filename.jpg or gif or png
#    filename.jpg or gif or png
#      movie cover image (attach file)
#    inline, inline=yes
#      inline window player
#    autoplay, autoplay=yes, autostart, autostart=yes
#      auto play when wiki page open
#    loop, loop=yes
#      movie loop (only Popup Windows Media / HTML video and HTML5 video)
#    notime, notime=yes
#      not display movie time
#    nodownload, nodownload=yes
#      not place download link
#    size=(0-100)%
#      inner player size
#    width=xxx height=xxx or 640x480
#      inner player size
#    youtube=ID
#      YouTube ID
#    niconico=ID
#      NicoVideo ID
#
########################################################################

$PLUGIN="playvideo";
$VERSION="2.2a";

use Nana::Cache;
use Nana::HTTP;
use Image::ExifTool;
require "plugin/counter.inc.pl";

$::playvideo_plugin_usedownload=1		# Ȥʤ0ˤ롣
	if(!defined($::playvideo_plugin_usedownload));
$::playvideo_plugin_plain_download=0	# wmvɤǤ褦ˤ
	if(!defined($::playvideo_plugin_plain_download));
$::playvideo_plugin_zipflags="-0";		# zipΥץ
$::playvideo_plugin_ziptmp="/tmp"		# zipեΥƥݥΰ
	if(!defined($::playvideo_plugin_ziptmp));
$::playvideo_plugin_videopath="video"
	if(!defined($::playvideo_plugin_videopath));
$::playvideo_plugin_playsite="http://$ENV{HTTP_HOST}/v.cgi"
	if(!defined($::playvideo_plugin_playsite));
$::playvideo_plugin_videourl="http://$ENV{HTTP_HOST}/$::playvideo_plugin_videopath"
	if(!defined($::playvideo_plugin_videourl));
# wmv ʳκȤꤹ롣
# ץ
#	$::playvideo_plugin_videourl{flv}=<<EOM;
#	http://v2.nanakochi.daiba.cx/videonanakochi
#	http://v3.nanakochi.daiba.cx/videonanakochi
#	http://v-flv.nanakochi.daiba.cx
#	EOM
#	$::playvideo_plugin_videourl{mp4}=<<EOM;
#	http://v2.nanakochi.daiba.cx/videonanakochi
#	http://v3.nanakochi.daiba.cx/videonanakochi
#	http://v-mp4.nanakochi.daiba.cx
#	http://v-mp4-2.nanakochi.daiba.cx
#	EOM
#	$::playvideo_plugin_videourl{ogv}=<<EOM;
#	http://v2.nanakochi.daiba.cx/videonanakochi
#	http://v3.nanakochi.daiba.cx/videonanakochi
#	http://v-ogv.nanakochi.daiba.cx
#	EOM
#	$::playvideo_plugin_videourl{webm}=<<EOM;
#	http://v2.nanakochi.daiba.cx/videonanakochi
#	http://v3.nanakochi.daiba.cx/videonanakochi
#	http://v-webm.nanakochi.daiba.cx
#	EOM

$::playvideo_plugin_videourl{flv}=$::playvideo_plugin_videourl
	if(!defined($::playvideo_plugin_videourl{flv}));
$::playvideo_plugin_videourl{mp4}=$::playvideo_plugin_videourl
	if(!defined($::playvideo_plugin_videourl{mp4}));
$::playvideo_plugin_videourl{ogv}=$::playvideo_plugin_videourl
	if(!defined($::playvideo_plugin_videourl{ogv}));
$::playvideo_plugin_videourl{webm}=$::playvideo_plugin_videourl
	if(!defined($::playvideo_plugin_videourl{webm}));

# wmvΥȥzip
$::playvideo_plugin_downloadfilename_inwmv=0
	if(!defined($::playvideo_plugin_downloadfilename_inwmv));
# wmvκԤzip
$::playvideo_plugin_downloadfilename_inwmv_withauthor=0
	if(!defined($::playvideo_plugin_downloadfilename_inwmv_withauthor));

# Youtubeεʪʥ˥˥ưˤѤ
$playvideo::usefakeyoutubeurl=0
	if(!defined($playvideo::usefakeyoutubeurl));

$::playvideo_plugin_zipcmds=<<EOM;
/usr/bin/zip
/usr/local/bin/zip
EOM

# wmv9
$playvideo::wmvid="CLSID:6BF52A52-394A-11d3-B153-00C04F79FAA6"
# wmv6
#$playvideo::wmvid="CLSID:22D6F312-B0F6-11D0-94AB-0080C74C7E95"
	if(!defined($playvideo::wmvid));

@HTML5_VIDEO_TARGETS_MP4=(
	"Safari 522",
	"MSIE 9",
	"iPad",
	"iPhone",
	"Android",
);

@HTML5_VIDEO_TARGETS_OGV=(
	"Fire[Ff]ox 4",
	"Fire[Ff]ox 3.6",
	"Fire[Ff]ox 3.5",
	"Opera Version 11",
	"Opera Version 10.9",
	"Opera Version 10.8",
	"Opera Version 10.7",
	"Opera Version 10.6",
	"Opera Version 10.5",
	"Chrome 3",
);

@HTML5_VIDEO_TARGETS_WEBM=(
	"Chrome 6",
	"Safari 522",
	"MSIE 9",	# ʲgoogleˤ륵ݡ
	"Fire[Ff]ox 4",
	"Fire[Ff]ox 3.6",
	"Fire[Ff]ox 3.5",
	"Opera Version 11",
	"Opera Version 10.9",
	"Opera Version 10.8",
	"Opera Version 10.7",
	"Opera Version 10.6",
	"Opera Version 10.5",
);

$wmv="wmv";
$ext="wvx";
$ext="asx"
	if($playvideo::wmvid eq "CLSID:22D6F312-B0F6-11D0-94AB-0080C74C7E95");
$zip="zip";
$dl="dl";
$flv="flv";
$mp4="mp4";
$ogv="ogv";
$webm="webm";
$vhtml="html";

$playvideo::playercount=0;
$playvideo::htmlplayer=0;
$playvideo::flvplayer=0;

sub plugin_playvideo_convert {
	return "<div>". &plugin_playvideo_inline(@_) . "</div>\n";
}

sub plugin_playvideo_inline {
	my ($args)=@_;
	my @args = split(/,/, $args);
	return 'no argument(s).' if (@args < 1);

	my %params;
	my $fname=shift @args;
	foreach(@args) {
		if(/=/) {
			my($l,$r)=split(/=/,$_);
			$l=~s/^(\-|\-\-)//g;
			$l=lc $l;
			$l="niconico" if($l=~/nico/);
			$params{$l}=$r;
		} else {
			if(/\.$::image_extention$/oi) {
				$params{image}=$_;
			} elsif(/^sm(\d+)/) {
				$params{niconico}=$_;
			} elsif(/^([0-9.]+)%$/i) {
				$params{size}=$1;
			} elsif(/^([0-9]+)x([0-9]+)$/i) {
				$params{width}=$1;
				$params{height}=$2;
			} elsif(/^(nodl|nodownload)$/) {
				$params{nodownload}="true";
			} elsif(/^(autoplay)$/) {
				$params{autostart}=1;
			} elsif(/^(notime|inline|autostart|loop)$/) {
				$params{$_}=1;
			} else {
				$params{youtube}=$_;
			}
		}
	}
	$youtube=$params{youtube};
	$nicovideo=$params{niconico};

	my $body;
	$videopath=$::playvideo_plugin_videopath;
	$playsite=$::playvideo_plugin_playsite;
	$videourl=$::playvideo_plugin_videourl;
	my $ffull=$fname;
	my $fext=$fname;
	$fext=~s/^.*\.//g;
	$fname=~s/\..*//g;

	my $browser=$ENV{HTTP_USER_AGENT};
	my $wmvtarget = "";
	if ($browser=~/MSIE/ || $browser=~/Opera/ ) {
	} else {
		$wmvtarget = "_blank";
	}

	$playvideo::nicovideourl=$::resouyrce{playvideo_niconico_url};
	$playvideo::youtubeurl=$::resource{playvideo_youtube_url};
	$playvideo::youtube_fakeniconico_url=$::resource{playvideo_youtube_fakeniconico_url};
	$playvideo::youtubeobject=$::resource{playvideo_youtube_object};
	$playvideo::nicovideoobject=$::resource{playvideo_niconico_object};

	my $cache=new Nana::Cache (
		ext=>"playvideo",
		files=>500,
		dir=>$::cache_dir,
		size=>100000,
		use=>1,
		expire=>1000000000000000
	);
	my $cachefile="playvideo_$fname";
	my $buf=$cache->read($cachefile,1);
	if(-r "$videopath/$fname.$wmv" || -r "$videopath/$fname.$mp4") {
		my $info;
		my $mp4info;
		my $mp4tag;
		my $title;
		my $author;
		my $copyright;
		my $time;
		if($buf eq '') {
			my $exifTool = new Image::ExifTool;
			if(-r "$videopath/$fname.$wmv") {
				$info = $exifTool->ImageInfo("$videopath/$fname.$wmv");
				$title=&Jcode::convert($$info{Title}, 'sjis');
				$author=&Jcode::convert($$info{Author}, 'sjis');
				$copyright=&Jcode::convert($$info{Copyright}, 'sjis');
				$time=$$info{PlayDuration};
			} elsif(&load_module("MP4::Info") && -r "$videopath/$fname.$mp4") {
				$info = $exifTool->ImageInfo("$videopath/$fname.$mp4");
				$mp4tag = MP4::Info::get_mp4tag("$videopath/$fname.$mp4");
				$title=&Jcode::convert($mp4tag->{NAM}, 'sjis');
				$author=&Jcode::convert($mp4tag->{ART} ne '' ? $mp4tag->{ART} : $mp4tag->{WRT}, 'sjis');
				$copyright=&Jcode::convert($author, 'sjis');
				$mp4info = MP4::Info::get_mp4info("$videopath/$fname.$mp4");
				$time = $mp4info->{TIME};
			} elsif(-r "$videopath/$fname.$mp4") {
				$info = $exifTool->ImageInfo("$videopath/$fname.$wmv");
				$title=&Jcode::convert($$info{Title}, 'sjis');
				$author="";
				$copyright="";
				$time="";
			}
			my $browserflg=&checkurl($fname,$mp4,$videopath,$videourl,%::playvideo_plugin_videourl) ne '' ? 1 : &checkurl($fname,$flv,$videopath,$videourl,%::playvideo_plugin_videourl) ne '' ? 2 : 0;
			$buf=<<EOM;
$time\t$title\t$author\t$copyright\t$$info{ImageWidth}\t$$info{ImageHeight}\t$browserflg
EOM
			$cache->write($cachefile,$buf);
		}
	} else {
		return &playvideo_err($fname, $::resource{playvideo_ext_wmv});
	}
	my ($time,$title,$author,$copyright,$width,$height,$browserflg)=split(/\t/,$buf);

	if($params{width} ne '' && $params{height} ne '') {
		$width=$params{width};
		$height=$params{height};
	} elsif($params{width} ne '') {
		my $_w=$width;
		$width=$params{width};
		my $tmp=$width / $_w;
		$height=$height * $tmp;
	} elsif($params{height} ne '') {
		my $_h=$height;
		$height=$params{height};
		my $tmp=$height / $_h;
		$width=$width * $tmp;
	}
	if($params{size} ne '') {
		$width=($width * $params{size} / 100);
		$height=($height * $params{size} / 100);
	}

	if($params{inline} ne "" || $fext=~/auto|inline|popup/) {
		if($browser=~/Fire[Ff]ox|Chrome|Safari|Opera|iPad|iPhone|Andoroid|Konqueror|Lunascape|Sleipnir/
			|| $browser=~/MSIE 9\./
			|| $browser=~/MSIE [1-9][0-9]\./) {
			$fext=$vhtml;
		}
		if($fext ne $vhtml && $browser=~/MSIE/ && $browser=~/Windows/) {
			$fext=$wmv;
		}
		if($fext!~/$wmv|$vhtml/) {
			$body.=qq(<span class="error">$::resource{playvideo_err_notsupport}</span>);
		}
	}
	if($fext eq $wmv) {
		if(-r "$videopath/$fname.$fext" ) {
			$playvideo::playercount++;
			&getbasehref;
			$body.=<<EOM;
<object id="Player$playvideo::playercount" width="$width" height="$height" classid="$playvideo::wmvid">
<param name="autoStart" value="@{[$params{autostart}+0 eq 0 ? 'false' : 'true']}" />
<param name="URL" value="$playsite/$fname.$ext" />
<embed src="$playsite/$fname.$ext" autostart="0" width="$width" height="$height"@{[$params{autostart}+0 eq 0 ? '' : ' autostart="autostart"']}></embed>
</object>
<!-- saved from url=(0022)$::basehost -->
EOM
			if($browser=~/Chrome/) {
				$body.="<br />" . $::resource{playvideo_wmv_chrome} . "<br />";
			}
		} else {
			return &playvideo_err($fname, $::resource{playvideo_ext_wmv});
		}
	} elsif($fext eq $vhtml) {
		if($browserflg+0 eq 1) {
			$playvideo::playercount++;
			$html5video=&html5video($fname,$::playvideo_plugin_videopath,$::playvideo_plugin_videourl,%::playvideo_plugin_videourl);
			if($html5video ne '' && &checkhtml5videosupport eq 1) {
				if($playvideo::htmlplayer eq 0) {
					$::htmlmode="html5_plugin";
					&init_dtd;
					$::IN_HEAD.=<<EOM;
<link rel="stylesheet" href="$::skin_url/video-js.css" type="text/css" media="screen" />
<script type="text/javascript"><!--
var swf="$::skin_url/video-js.swf";
//--></script>
<script src="$::skin_url/video.js" type="text/javascript"></script>
EOM
				}
				$playvideo::htmlplayer++;
				$body.=<<EOM;
<video id="playvideo$playvideo::playercount" class="video-js vjs-default-skin" width="$width" height="$height" controls="controls" preload="auto" data-setup="{}"@{[$params{autostart}+0 ne 0 ? ' autoplay="autoplay"' : '']}@{[$params{loop}+0 ne 0 ? ' loop="loop"' : '']}@{[$params{image} ne '' ? qq( poster="$params{image}") : '']}>
$html5video
</video>
EOM
			} else {
				if($playvideo::flvplayer eq 0) {
					$::IN_HEAD.=<<EOM;
<script type="text/javascript" src="$::skin_url/flowplayer-3.2.6.min.js"></script>
<script src="$::skin_url/videoresize.js" type="text/javascript"$csscharset></script>
EOM
				}
				$videopath=$::playvideo_plugin_videopath;
				$videourl=$::playvideo_plugin_videourl;
				$flvpath=&checkurl($fname,$flv,$videopath,$videourl,%::playvideo_plugin_videourl);
				$flvpath=&checkurl($fname,$mp4,$videopath,$videourl,%::playvideo_plugin_videourl)
					if($flvpath eq '');
				$playvideo::flvplayer++;
				my $js_flv_noauto='flowplayer("player",swf,{clip:{url:flv,autoPlay:false,autoBuffering:true,scaling:"fit"},canvas:{backgroundColor:"#000000",backgroundGradient:"none"},plugins:{controls:{height:24,play:true,stop:true,volume:true,mute:true,time:true,fullscreen:true,volumeSliderColor:"#000000",tooltipColor:"#5F747C",progressColor:"#112233",bufferColor:"#445566",buttonColor:"#5F747C",sliderColor:"#000000",backgroundGradient:"high",durationColor:"#ffffff",backgroundColor:"#222222",progressGradient:"medium",borderRadius:"0",buttonOverColor:"#728B94",bufferGradient:"none",timeBgColor:"#555555",sliderGradient:"none",volumeSliderGradient:"none",tooltipTextColor:"#ffffff",timeColor:"#01DAFF"}}});';
				my $js_flv_noauto_loop='flowplayer("player",swf,{clip:{url:flv,autoPlay:false,autoBuffering:true,scaling:"fit"},canvas:{backgroundColor:"#000000",backgroundGradient:"none"},plugins:{controls:{height:24,play:true,stop:true,volume:true,mute:true,time:true,loop:true,fullscreen:true,volumeSliderColor:"#000000",tooltipColor:"#5F747C",progressColor:"#112233",bufferColor:"#445566",buttonColor:"#5F747C",sliderColor:"#000000",backgroundGradient:"high",durationColor:"#ffffff",backgroundColor:"#222222",progressGradient:"medium",borderRadius:"0",buttonOverColor:"#728B94",bufferGradient:"none",timeBgColor:"#555555",sliderGradient:"none",volumeSliderGradient:"none",tooltipTextColor:"#ffffff",timeColor:"#01DAFF"}}});';
				my $js_flv='flowplayer("player",swf,{clip:{url:flv,autoPlay:true,autoBuffering:true,scaling:"fit"},canvas:{backgroundColor:"#000000",backgroundGradient:"none"},plugins:{controls:{height:24,play:true,stop:true,volume:true,mute:true,time:true,fullscreen:true,volumeSliderColor:"#000000",tooltipColor:"#5F747C",progressColor:"#112233",bufferColor:"#445566",buttonColor:"#5F747C",sliderColor:"#000000",backgroundGradient:"high",durationColor:"#ffffff",backgroundColor:"#222222",progressGradient:"medium",borderRadius:"0",buttonOverColor:"#728B94",bufferGradient:"none",timeBgColor:"#555555",sliderGradient:"none",volumeSliderGradient:"none",tooltipTextColor:"#ffffff",timeColor:"#01DAFF"}}});';
				my $js_flv_loop='flowplayer("player",swf,{clip:{url:flv,autoPlay:true,autoBuffering:true,scaling:"fit"},canvas:{backgroundColor:"#000000",backgroundGradient:"none"},plugins:{controls:{height:24,play:true,stop:true,volume:true,mute:true,time:true,loop:true,fullscreen:true,volumeSliderColor:"#000000",tooltipColor:"#5F747C",progressColor:"#112233",bufferColor:"#445566",buttonColor:"#5F747C",sliderColor:"#000000",backgroundGradient:"high",durationColor:"#ffffff",backgroundColor:"#222222",progressGradient:"medium",borderRadius:"0",buttonOverColor:"#728B94",bufferGradient:"none",timeBgColor:"#555555",sliderGradient:"none",volumeSliderGradient:"none",tooltipTextColor:"#ffffff",timeColor:"#01DAFF"}}});';
				$body.=<<EOM;
<div id="page">
<div style="width:@{[$width]};height:@{[$height]}px" id="player"></div>
<script type="text/javascript"><!--
var swf="$::skin_url/flowplayer-3.2.7.swf";
var flv="$flvpath";
window.focus();
@{[$params{autostart}+0 eq 0
	? @{[$params{loop}+0 eq 0
		? $js_flv_noauto : $js_flv_noauto_loop
	  ]}
	: @{[$params{loop}+0 eq 0
		? $js_flv : $js_flv_loop
	  ]}
]}
//--></script>
</div>
EOM
			}
		}
	}
 elsif($fext=~/^sm(\d+)/) {
		my $id=$1;
		my $tmp=$playvideo::nicovideoobject;
		$tmp=~s/##ID##/sm$id/g;
		$body.=$tmp;
	} elsif($fext ne '' && $ffull=~/\./) {
		my $id=$fext;
		my $tmp=$playvideo::youtubeobject;
		$tmp=~s/##ID##/$id/g;
		$body.=$tmp;
	} else {
		my $wmvload=0;
		my $loopext=".loop" if($params{loop}+0 ne 0);
		if(-r "$videopath/$fname.$wmv") {
			$wmvload=1;
			$body.=<<EOM;
<strong>@{[&make_link_target("$playsite/$fname$loopext.$ext","",$wmvtarget,"$::resource{playvideo_wmp_play}")]}
[$::resource{playvideo_wmp_play}]</a></strong>
EOM
		}
		if($browserflg+0 eq 1) {
#	if(-r "$videopath/$fname.$mp4" || -r "$videopath/$fname.$ogv" || -r "$videopath/$fname.$webm") {
			$body.=<<EOM;
@{[$wmvload eq 0 ? '<strong>' : '']}<a href="$playsite/$fname$loopext.$vhtml" title="[$::resource{playvideo_html5video_play}]" onclick="window.open('$playsite/$fname$loopext.$vhtml','_player','location=no,status=no,toolbar=no,hotkeys=no,directories=no,scrollbars=no,resizable=yes,menubar=no,width=1,height=1');return false;">
[$::resource{playvideo_html5video_play}]</a>@{[$wmvload eq 0 ? '</strong>' : '']}
EOM
#		} elsif(-r "$videopath/$fname.$flv") {
		} elsif($browserflg+0 eq 2) {
			$body.=<<EOM;
<a href="$playsite/$fname$loopext.$flv" title="[$::resource{playvideo_flashvideo_play}]" onclick="window.open('$playsite/$fname$loopext.$flv','_player','location=no,status=no,toolbar=no,hotkeys=no,directories=no,scrollbars=no,resizable=yes,menubar=no,width=1,height=1');return false;">
[$::resource{playvideo_flashvideo_play}]</a>
EOM
		}
		if($youtube ne '') {
			$body.=<<EOM;
@{[&make_link_target("$playsite/$fname.$youtube","","_blank","$::resource{playvideo_youtube_play}")]}
[$::resource{playvideo_youtube_play}]</a>
EOM
		}
		if($nicovideo ne '') {
			$body.=<<EOM;
@{[&make_link_target("$playsite/$fname.$nicovideo","","_blank","$::resource{playvideo_nicovideio_play}")]}
[$::resource{playvideo_nicovideio_play}]</a>
EOM
		}
		if($::playvideo_plugin_usedownload eq 1 && $params{nodownload} eq "") {
			if($::playvideo_plugin_plain_download eq 1) {
				$body.=<<EOM;
@{[&make_link_target("$playsite/$fname.$dl","","","$::resource{playvideo_download}")]}
[$::resource{playvideo_download}]</a>
EOM
			} else {
				$body.=<<EOM;
@{[&make_link_target("$playsite/$fname.$zip","","","$::resource{playvideo_download}")]}
[$::resource{playvideo_download}]</a>
EOM
			}
		}
		$body.=<<EOM if($params{notime} eq "");
($time)
<br />
EOM
		%vcounter=&plugin_counter_do("playvideo_$fname","r");
		$body.=<<EOM;
<span class="counter">
$::resource{playvideo_total}: $vcounter{total} $::resource{playvideo_today}: $vcounter{today} $::resource{playvideo_yesterday}:$vcounter{yesterday}
</span>
EOM
	}
	return $body;
}

sub playvideo_err {
	my($f, $n)=@_;
	my $r=$::resource{playvideo_err_notfound};
	$r=~s/\$1/$f/g;
	$r=~s/\$2/$n/g;
	return qq(<span class="error">$r</span>);
}

sub html5video {
	my($file,$path,$videourl,%videourls)=@_;

	my $agent=$ENV{HTTP_USER_AGENT};
	my $tag="";
	my $url;

	if(($url=&checkurl($file,$mp4,$path,$videourl,%videourls)) ne '') {
		$tag.=<<EOM;
<source src="$url" type="video/mp4" />
EOM
	}

	if(($url=&checkurl($file,$ogv,$path,$videourl,%videourls)) ne '') {
		$tag.=<<EOM;
<source src="$url" type='video/ogg; codecs="theora, vorbis"' />
EOM
	}

	if(($url=&checkurl($file,$webm,$path,$videourl,%videourls)) ne '') {
		$tag.=<<EOM;
<source src="$url" type='video/webm; codecs="vp8, vorbis"' />
EOM
	}

	return $tag;
}

sub checkurl {
	my ($file,$ext,$path,$url,%urls)=@_;
	if(-r "$path/$file.$ext") {
		return "$url/$file.$ext";
	}

	if($::package eq '' || $::version eq '') {
		open(R,"$::explugin_dir/wiki.cgi");
		foreach(<R>) {
			if(/\$\:\:package/) {
				eval $_ ;
			}
			if(/\$\:\:version/) {
				eval $_ ;
			}
		}
		close(R);
	}

	foreach (split(/\n/,$urls{$ext})) {
		my $http=new Nana::HTTP('plugin'=>"playvideo");
		s/\/$//;
		my ($result, $stream) = $http->head("$_/$file.$ext");
		if($result eq 0) {
			return "$_/$file.$ext";
		}
	}
	return "";
}

sub checkhtml5videosupport {
	my $agent=$ENV{HTTP_USER_AGENT};
	my $html5supportflg=0;

	foreach(@HTML5_VIDEO_TARGETS_MP4) {
		my($arg1,$arg2,$arg3)=split(/ /,$_);
		if($arg2 eq "") {
			if($agent=~/$arg1/) {
				$html5supportflg=1;
			}
		} elsif($arg3 eq "") {
			if($agent=~/$arg1[\s|\/](\d+)\./) {
				if($1 >= $arg2) {
					$html5supportflg=1;
				}
			} else {
				if($agent=~/$arg1[\s|\/](\d+)\./) {
					if($1 >= $arg2) {
						$html5supportflg=1;
					}
				}
			}
			if($1 >= $arg2) {
				$html5supportflg=1;
			}
		} elsif($agent=~/$arg1/) {
			if($agent=~/$arg2[\s|\/](\d+)\./) {
				if($1 >= $arg3) {
					$html5supportflg=1;
				}
			}
		}
	}

	foreach(@HTML5_VIDEO_TARGETS_OGV) {
		my($arg1,$arg2,$arg3)=split(/ /,$_);
		if($arg3 eq "") {
			if($agent=~/$arg1[\s|\/](\d+)\./) {
				if($1 >= $arg2) {
					$html5supportflg=1;
				}
			} else {
				if($agent=~/$arg1[\s|\/](\d+)\./) {
					if($1 >= $arg2) {
						$html5supportflg=1;
					}
				}
			}
			if($1 >= $arg2) {
				$html5supportflg=1;
			}
		} elsif($agent=~/$arg1/) {
			if($agent=~/$arg2[\s|\/](\d+)\./) {
				if($1 >= $arg3) {
					$html5supportflg=1;
				}
			}
		}
	}

	foreach(@HTML5_VIDEO_TARGETS_WEBM) {
		my($arg1,$arg2,$arg3)=split(/ /,$_);
		if($arg3 eq "") {
			if($agent=~/$arg1[\s|\/](\d+)\./) {
				if($1 >= $arg2) {
					$html5supportflg=1;
				}
			} else {
				if($agent=~/$arg1[\s|\/](\d+)\./) {
					if($1 >= $arg2) {
						$html5supportflg=1;
					}
				}
			}
			if($1 >= $arg2) {
				$html5supportflg=1;
			}
		} elsif($agent=~/$arg1/) {
			if($agent=~/$arg2[\s|\/](\d+)\./) {
				if($1 >= $arg3) {
					$html5supportflg=1;
				}
			}
		}
	}
	return $html5supportflg;
}

sub init_dtd {
	%::dtd = (
		"html4"=>qq(<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">\n<html lang="$::lang">\n<head>\n<meta http-equiv="Content-Language" content="$::lang" />\n<meta http-equiv="Content-Type" content="text/html; charset=$::charset" />\n<meta http-equiv="Content-Style-Type" content="text/css" />\n<meta http-equiv="Content-Script-Type" content="text/javascript" />),
		"xhtml11"=>qq(<?xml version="1.0" encoding="$::charset" ?>\n<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.1//EN" "http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd">\n<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="$::lang">\n<head>),
		"xhtml10"=>qq(<?xml version="1.0" encoding="$::charset" ?>\n<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">\n<html xmlns="http://www.w3.org/1999/xhtml" lang="$::lang" xml:lang="$::lang">\n<head>\n<meta http-equiv="Content-Language" content="$::lang" />\n<meta http-equiv="Content-Type" content="application/xhtml+xml; charset=$::charset" />),
		"xhtml10t"=>qq(<?xml version="1.0" encoding="$::charset" ?>\n<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">\n<html xmlns="http://www.w3.org/1999/xhtml" lang="$::lang" xml:lang="$::lang">\n<head>\n<meta http-equiv="Content-Language" content="$::lang" />\n<meta http-equiv="Content-Type" content="application/xhtml+xml; charset=$::charset" />),
		"xhtmlbasic10"=>qq(<?xml version="1.0" encoding="$::charset" ?>\n<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML Basic 1.0//EN" "http://www.w3.org/TR/xhtml-basic/xhtml-basic10.dtd">\n<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="$::lang">\n<head>\n<meta http-equiv="Content-Language" content="$::lang" />\n<meta http-equiv="Content-Type" content="application/xhtml+xml; charset=$::charset" />),
		"html5_plugin"=>qq(<!doctype html>\n<html lang="$::lang">\n<head>\n<meta http-equiv="content-type" content="text/html; charset=$::charset" /><meta http-equiv="Content-Style-Type" content="text/css" />\n<meta http-equiv="Content-Script-Type" content="text/javascript" />),
	);

	$::dtd=$::dtd{$::htmlmode};
	$::dtd=$::dtd{html4} if($::dtd eq '') || &is_no_xhtml(0);
	$::dtd.=qq(\n<meta name="generator" content="PyukiWiki $::version" />\n);

	$::is_xhtml=$::dtd=~/xhtml/;
}


1;
__END__
=head1 NAME

playvideo.inc.pl - PyukiWiki External Plugin

=head1 SYNOPSIS

Playvideo Plugin

=head1 SEE ALSO

=over 4

=item PyukiWiki/Plugin/Nanami/playvideo/

L<http://pyukiwiki.sfjp.jp/PyukiWiki/Plugin/Nanami/playvideo/>

=item PyukiWiki CVS

L<http://sfjp.jp/cvs/view/pyukiwiki/PyukiWiki-Devel/v.cgi?view=log>

L<http://sfjp.jp/cvs/view/pyukiwiki/PyukiWiki-Devel-UTF8/v.cgi?view=log>

L<http://sfjp.jp/cvs/view/pyukiwiki/PyukiWiki-Devel/plugin/playvideo.inc.pl?view=log>

L<http://sfjp.jp/cvs/view/pyukiwiki/PyukiWiki-Devel-UTF8/plugin/playvideo.inc.pl?view=log>

L<http://sfjp.jp/cvs/view/pyukiwiki/PyukiWiki-Devel/plugin/playvideo_v_cgi.pl?view=log>

L<http://sfjp.jp/cvs/view/pyukiwiki/PyukiWiki-Devel-UTF8/plugin/playvideo_v_cgi.pl?view=log>

=back

=head1 AUTHOR

=over 4

=item Nanami

L<http://nanakochi.daiba.cx/> etc...

=item PyukiWiki Developers Team

L<http://pyukiwiki.sfjp.jp/>

=back

=head1 LICENSE

Copyright (C) 2005-2012 by Nanami.

Copyright (C) 2005-2012 by PyukiWiki Developers Team

License is GNU GENERAL PUBLIC LICENSE 3 and/or Artistic 1 or each later version.

This program is free software; you can redistribute it and/or
modify it under the same terms as Perl itself.

=cut
