############################################################
# playvideo plugin
# playvideo.inc.pl
# Copyright(c) 2011 Nanami.
# for PyukiWiki 0.1.7 (http://nanakochi.daiba.cx/)
#
#
# 2011/10/07 change: 複数のサイトに動画が分散していても対応できるようにした。
#                    ただし、wmvだけはPyukiWikiと同じサイトに設置しなければ
#                    いけませんが、mp4やflvも別サイトに設置することが
#                    できるようになった。
#                    このバージョンにするには、deletecache をする必要があり、
#                    かつ、FLV、MP4ファイルを消去した場合、もう一度 deletecache
#                    をする必要があります。
#                    無圧縮zip以外にも、生のWMVファイルをダウンロードできる
#                    ようにした。（デフォルトは無圧縮zip）
# 2011/10/05 change: HEADリクエストを用いて、WMV以外の拡張子の動画を
#                    PyukiWikiが設置してあるサーバー以外に設定できるように
#                    した。また、IE 9 において、video.jsを無効化した。
# 2011/10/02 change: HTML5プレイヤーに対応、その為、HTML5ブラウザーでなく
#                    Flashで再生する場合に、別途MP4ファイルが必要になる。
#                    その時の変換フォーマットは、FlowPlayerが認識するように
#                    MPEG4 AVC/H.264形式で変換しなければならない。
#                    旧来のFlashでの再生もサポートしていますが、IE10の
#                    デスクトップ版以外でサポートされなくなるため、互換性の為に
#                    準備だけはしてあります。
#                    IE9の不具合で、IE9においては、HTML5プレイヤーは使用
#                    できないようになっています。
# 2011/09/11 change: デフォルトのスキンを読み込めるようにした。
#                    FireFoxでキー操作により動画のリロードするのを阻止した。
#                    設定してある漢字コードで出力できるようにした。
# 2011/06/12 change: flv動画にも対応した。ただし、wmvも必要です。
# 2011/05/26 change: wmvにタグが付けられている場合、zipファイルのダウンロード
#                    ファイル名をその名前に指定できるようにした。
# 2011/05/26 change: info/setup.cgiに対応した
# 2011/03/14 change: Content-disposition: attachment; filename="$file.wvx"
#                    を出力すると問題がある可能性があるため、出力を
#                    抑制した。
# 2011/03/01 change: 拡張子をwvxに変更した。
#                    Content-Type: video/x-ms-wvx を出力した。
#                    Content-disposition: attachment; filename="$file.wvx"
#                    を出力した。
# 2010/12/10 change: ニコニコ動画に対応した。
# 2010/12/10 change: ニコニコ動画に対応した
# 2010/11/13 change: 無圧縮zipでダウンロードできるようにした。
#                    大量の動画があるときキャッシュから取得するように
#                    した。ただし、有効期限は１時間です。
# 2010/10/27 change: MSIE とOpera以外はWindwos Mediaプレイヤー
#                    再生時に_blank(実質別タブ）になるようにした。
#                    Safariでは本当に別窓になります。
# 2010/10/24 change: use sub make_link_target
#
# 1TAB=4Spaces

use Nana::Cache;
use Nana::HTTP;
use Image::ExifTool;
require "plugin/counter.inc.pl";

$::playvideo_plugin_usedownload=1		# 使わない時は0にする。
	if(!defined($::playvideo_plugin_usedownload));
$::playvideo_plugin_plain_download=0	# 生のwmvをダウンロードできるようにする
	if(!defined($::playvideo_plugin_plain_download));
$::playvideo_plugin_zipflags="-0";		# zipのオプション
$::playvideo_plugin_ziptmp="/tmp"		# zipファイルのテンポラリの位置
	if(!defined($::playvideo_plugin_ziptmp));
$::playvideo_plugin_videopath="video"
	if(!defined($::playvideo_plugin_videopath));
$::playvideo_plugin_playsite="http://$ENV{HTTP_HOST}/v.cgi"
	if(!defined($::playvideo_plugin_playsite));
$::playvideo_plugin_videourl="http://$ENV{HTTP_HOST}/$::playvideo_plugin_videopath"
	if(!defined($::playvideo_plugin_videourl));
# wmv 以外の再生サイトを設定する。
# サンプル
#	$::playvideo_plugin_videourl{flv}=<<EOM;
#	http://v2.nanakochi.daiba.cx/videonanakochi
#	http://v3.nanakochi.daiba.cx/videonanakochi
#	http://v-flv.nanakochi.daiba.cx
#	EOM
#	$::playvideo_plugin_videourl{mp4}=<<EOM;
#	http://v2.nanakochi.daiba.cx/videonanakochi
#	http://v3.nanakochi.daiba.cx/videonanakochi
#	http://v-mp4.nanakochi.daiba.cx
#	http://v-mp4-2.nanakochi.daiba.cx
#	EOM
#	$::playvideo_plugin_videourl{ogv}=<<EOM;
#	http://v2.nanakochi.daiba.cx/videonanakochi
#	http://v3.nanakochi.daiba.cx/videonanakochi
#	http://v-ogv.nanakochi.daiba.cx
#	EOM
#	$::playvideo_plugin_videourl{webm}=<<EOM;
#	http://v2.nanakochi.daiba.cx/videonanakochi
#	http://v3.nanakochi.daiba.cx/videonanakochi
#	http://v-webm.nanakochi.daiba.cx
#	EOM

$::playvideo_plugin_videourl{flv}=$::playvideo_plugin_videourl
	if(!defined($::playvideo_plugin_videourl{flv}));
$::playvideo_plugin_videourl{mp4}=$::playvideo_plugin_videourl
	if(!defined($::playvideo_plugin_videourl{mp4}));
$::playvideo_plugin_videourl{ogv}=$::playvideo_plugin_videourl
	if(!defined($::playvideo_plugin_videourl{ogv}));
$::playvideo_plugin_videourl{webm}=$::playvideo_plugin_videourl
	if(!defined($::playvideo_plugin_videourl{webm}));

# wmvのタイトルをzipに埋め込む
$::playvideo_plugin_downloadfilename_inwmv=0
	if(!defined($::playvideo_plugin_downloadfilename_inwmv));
# wmvの作者をzipに埋め込む
$::playvideo_plugin_downloadfilename_inwmv_withauthor=0
	if(!defined($::playvideo_plugin_downloadfilename_inwmv_withauthor));

$::playvideo_plugin_zipcmds=<<EOM;
/usr/bin/zip
/usr/local/bin/zip
EOM

$wmv="wmv";
$ext="wvx";
$zip="zip";
$dl="dl";
$flv="flv";
$mp4="mp4";
$ogv="ogv";
$webm="webm";
$vhtml="html";

sub plugin_playvideo_inline {
	my ($arg)=@_;
	my ($fname,$youtube,$nicovideo)=split(/,/,$arg);
	my $body;

	$videopath=$::playvideo_plugin_videopath;
	$playsite=$::playvideo_plugin_playsite;
	$videourl=$::playvideo_plugin_videourl;
	$fname=~s/\..*//g;

	my $browser=$ENV{HTTP_USER_AGENT};
	my $wmvtarget = "";
	if ($browser=~/MSIE/ || $browser=~/Opera/ ) { 
	} else {
		$wmvtarget = "_blank";
	}

	my $cache=new Nana::Cache (
		ext=>"playvideo",
		files=>500,
		dir=>$::cache_dir,
		size=>100000,
		use=>1,
		expire=>1000000000000000
	);
	my $cachefile="playvideo_$fname";
	my $buf=$cache->read($cachefile,1);
	if(-r "$videopath/$fname.$wmv") {
		if($buf eq '') {
			my $exifTool = new Image::ExifTool;
			my $info = $exifTool->ImageInfo("$videopath/$fname.$wmv");
			my $title=&Jcode::convert($$info{Title}, 'sjis');
			my $author=&Jcode::convert($$info{Author}, 'sjis');
			my $copyright=&Jcode::convert($$info{Copyright}, 'sjis');
			my $browserflg=&checkurl($fname,$mp4,$videopath,$videourl,%::playvideo_plugin_videourl) ne '' ? 1 : &checkurl($fname,$flv,$videopath,$videourl,%::playvideo_plugin_videourl) ne '' ? 2 : 0;
			$buf=<<EOM;
$$info{SendDuration}\t$title\t$author\t$copyright\t$$info{ImageWidth}\t$$info{ImageHeight}\t$browserflg
EOM
			$cache->write($cachefile,$buf);
		}
	}
	my ($time,$title,$author,$copyright,$width,$height,$browserflg)=split(/\t/,$buf);
	$body.=<<EOM;
<strong>
@{[&make_link_target("$playsite/$fname.$ext","",$wmvtarget,"Windows Media Player")]}
[Windows Media Player]</a></strong>
EOM
	if($browserflg+0 eq 1) {
#	if(-r "$videopath/$fname.$mp4" || -r "$videopath/$fname.$ogv" || -r "$videopath/$fname.$webm") {
		my $footer=20;
 		$footer=-50 if($ENV{HTTP_USER_AGENT}=~/Safari/);
		$footer=35 if($ENV{HTTP_USER_AGENT}=~/Chrome/);
		$body.=<<EOM;
<a href="#" title="[ブラウザーで再生]" onclick="window.open('$playsite/$fname.$vhtml','_player','location=no,status=no,toolbar=no,hotkeys=no,directories=no,scrollbars=no,resizable=yes,menubar=no,width=$width,height=@{[$height+$footer]}');return false;">
[ブラウザーで再生]</a>
EOM
#	} elsif(-r "$videopath/$fname.$flv") {
	} elsif($browserflg+0 eq 2) {
		my $footer=20;
 		$footer=-50 if($ENV{HTTP_USER_AGENT}=~/Safari/);
		$footer=35 if($ENV{HTTP_USER_AGENT}=~/Chrome/);
		$body.=<<EOM;
<a href="#" title="[ブラウザーで再生]" onclick="window.open('$playsite/$fname.$flv','_player','location=no,status=no,toolbar=no,hotkeys=no,directories=no,scrollbars=no,resizable=yes,menubar=no,width=$width,height=@{[$height+$footer]}');return false;">
[ブラウザーで再生]</a>
EOM
	}
	if($youtube ne '') {
		$body.=<<EOM;
@{[&make_link_target("$playsite/$fname.$youtube","","_blank","Youtube")]}
[Youtube]</a>
EOM
	}

	if($nicovideo ne '') {
		$body.=<<EOM;
@{[&make_link_target("$playsite/$fname.$nicovideo","","_blank","ニコニコ動画")]}
[ニコニコ動画]</a>
EOM
	}
	if($::playvideo_plugin_usedownload eq 1) {
		if($::playvideo_plugin_plain_download eq 1) {
			$body.=<<EOM;
@{[&make_link_target("$playsite/$fname.$dl","","","ダウンロード")]}
[ダウンロード]</a>
EOM
		} else {
			$body.=<<EOM;
@{[&make_link_target("$playsite/$fname.$zip","","","ダウンロード")]}
[ダウンロード]</a>
EOM
		}
	}

	$body.=<<EOM;
($time)
<br />
EOM
	%vcounter=&plugin_counter_do("playvideo_$fname","r");
	$body.=<<EOM;
<span style="font-size: 10px;">
TOTAL: $vcounter{total} TODAY: $vcounter{today} YESTERDAY:$vcounter{yesterday}
</span>
EOM

	return $body;
}

sub checkurl {
	my ($file,$ext,$path,$url,%urls)=@_;

	if(-r "$path/$file.$ext") {
		return "$url/$file.$ext";
	}

	if($::package eq '' || $::version eq '') {
		open(R,"$::explugin_dir/wiki.cgi");
		foreach(<R>) {
			if(/\$\:\:package/) {
				eval $_ ;
			}
			if(/\$\:\:version/) {
				eval $_ ;
			}
		}
		close(R);
	}

	foreach (split(/\n/,$urls{$ext})) {
		my $http=new Nana::HTTP('plugin'=>"playvideo");
		s/\/$//;
		my ($result, $stream) = $http->head("$_/$file.$ext");
		if($result eq 0) {
			return "$_/$file.$ext";
		}
	}
	return "";
}

1;
