#!/usr/bin/perl
BEGIN {
	push @INC, 'lib';
	unshift @INC, 'lib';
}

require "pyukiwiki.ini.cgi";
require "plugin/counter.inc.pl";
require "plugin/playvideo.inc.pl";
$::counter_ext = '.count';
$::info_dir="./info";
use Jcode;
use Image::ExifTool;
#use LWP::UserAgent;

&main;

sub main {
	foreach my $i (0x00 .. 0xFF) {
		$::_urlescape{chr($i)} = sprintf('%%%02x', $i);
		$::_dbmname_encode{chr($i)} = sprintf('%02X', $i);
	}

	$ENV{PATH_INFO}=~s/^\///g;
	$file=$ENV{PATH_INFO};
	$file=~s/\..*//g;
	$ext=$ENV{PATH_INFO};
	$ext=~s/.*\.//g;
	$wmv="wmv";
	$videopath="videonanakochi";
	$videourl="http://$ENV{HTTP_HOST}/$videopath";

	my $exifTool = new Image::ExifTool;
	my $info = $exifTool->ImageInfo("$videopath/$file.$wmv");

	$title=&Jcode::convert($$info{Title}, 'sjis', 'utf8');
	$author=&Jcode::convert($$info{Author}, 'sjis', 'utf8');
	$copyright=&Jcode::convert($$info{Copyright}, 'sjis', 'utf8');
	if($ext eq "asx") {
		&plugin_counter_do("playvideo_$file","w");
		print <<EOM;
Content-Type: video/x-ms-wmv

<asx version="3.0">
<entry>
<title>$$info{Title}</title>
<author>$$info{Author}</author>
<copyright>$$info{Copyright}</copyright>
<ref href="$videourl/$file.$wmv" />
</entry>
</asx>
EOM
	} else {
		&plugin_counter_do("playvideo_$file","w");
		print <<EOM;
Location: http://www.youtube.com/watch?v=$ext

EOM
	}
}

sub is_exist_page {
	return 1;
}

sub encode {
	my ($encoded) = @_;
	$encoded =~ s/(\W)/$::_urlescape{$1}/g;
	return $encoded;
}

sub dbmname {
	my ($name) = @_;
	$name =~ s/(.)/$::_dbmname_encode{$1}/g;
	return $name;
}

my $_tz='';
sub gettz {
	if($_tz eq '') {
		$_tz=(localtime(time))[2]+(localtime(time))[3]*24+(localtime(time))[4]*24
			+(localtime(time))[5]*24-(gmtime(time))[2]-(gmtime(time))[3]*24
			-(gmtime(time))[4]*24-(gmtime(time))[5]*24;
	}
	return $_tz;
}
