#!/usr/bin/python
# coding: utf-8

import os, sys                  # for daemonize
import SocketServer, urllib, socket     # for service
import re
import  gettext
import locale
import logging, logging.config # for logging
import codecs                  # for console in/output encoding
import ConfigParser

conf = None
encoding = ''

# utility functions
def isContentOnly(seq, aset):
    for c in seq:
        if c not in aset:
            return False
        pass
    return True

def isContentAny(seq, aset):
    for c in seq:
        if c in aset:
            return True
        pass
    return False

def buildTranslater(*args, **kwds):
    import logging, logging.handlers

    tmp = dict(*args, **kwds)
    rtrns = re.compile('|'.join(map(re.escape, tmp)))
    def translateOne(match):
        return tmp[match.group(0)]
    def translate(text):
        return rtrns.sub(translateOne, text)
    return translate

def setupLogger():
    '''
    loggingモジュールの初期化
    それぞれの出力先は設定ファイルとして与える
    この関数を通過以降は logging を通じてログ出力が可能となる
    '''
    if conf.getboolean('log', 'filelog'):
        if sys.platform == 'win32':
            logging.config.fileConfig('filelogwin.ini')
            pass
        else:
            logging.config.fileConfig('filelog.ini')
            pass
        pass
    if sys.platform == 'win32':
        if conf.getboolean('log', 'ntevent'):
            # このログ出力先はログソースの設定などのためHKLMへのレジストリ書き込むため管理者権限が必要
            logging.config.fileConfig('ntevent.ini')
            pass
        pass
    else:
        if conf.getboolean('log', 'syslog'):
            logging.config.fileConfig('syslog.ini')
            pass
        pass
    if not conf.getboolean('server', 'debug'):
        logging.getLogger().setLevel(logging.INFO)
        pass
    else:
        logging.getLogger().setLevel(logging.DEBUG)
        pass
    return

def debug_method(arg):
    try:
        logging.debug(u'"%s"\n' % arg.decode(SocialSKKRequestHandler.CLIENT_CHARSET))
    except UnicodeDecodeError:
        try:
            logging.debug(u'"%s"\n' % arg.decode(SocialSKKRequestHandler.SERVER_CHARSET))
        except UnicodeDecodeError:
            logging.debug('"%r"\n' % arg)
            pass
        pass
    except UnicodeEncodeError:
        logging.debug(u'"%s"\n' % arg)
        pass
    return

def parseoptions():
    '''
    起動オプションを解析する
    大域変数 options に解析結果を格納する
    '''
    import optparse
    global parser
    parser = optparse.OptionParser()
    d = conf.getint('server', 'port')
    parser.add_option('-p', '--port', type='int', dest='port', default=d, help=_('server port number'))
    d = conf.getboolean('server', 'debug')
    parser.add_option('-d', '--debug', action='store_true', dest='debug', default=d, help=_('debugging log to error log file'))
    d = conf.getboolean('log', 'filelog')
    parser.add_option('-f', '--filelog', action='store_true', dest='filelog', default=d, help=_('log to file'))
    if sys.platform == 'win32':
        d = conf.getboolean('log', 'ntevent')
        parser.add_option('-e', '--eventlog', action='store_true', dest='ntevent', default=d, help=_('log to Event Log'))
        pass
    else:
        # loggingモジュールを使用するようになったのでデーモンの標準入出力は/dev/nullへ送り込む
        #parser.add_option('-l', '--log', type='string', dest='log', default='/tmp/skkserv.log', help=_('log filename'))
        #parser.add_option('-e', '--errorlog', type='string', dest='err', default='/tmp/skkserv.err', help=_('error log filename'))
        d = str(conf.get('server', 'pidfile', '/tmp/skkserv.run'))
        parser.add_option('-r', '--pidfile', type='string', dest='run', default=d, help=_('process id file'))
        d = conf.getboolean('log', 'syslog')
        parser.add_option('-s', '--syslog', action='store_true', dest='syslog', default=d, help=_('log to syslog'))
        pass
    # 解析対象外となった引数を他の解析処理に行なわせるため
    (options, args) = parser.parse_args()
    if hasattr(options, 'port'):
        conf.set('server', 'port', str(options.port))
        pass
    if hasattr(options, 'debug'):
        conf.set('server', 'debug', str(options.debug))
        pass
    if hasattr(options, 'filelog'):
        conf.set('log', 'filelog', str(options.filelog))
        pass
    if hasattr(options, 'ntevent'):
        conf.set('log', 'ntevent', str(options.ntevent))
        pass
    if hasattr(options, 'run'):
        conf.set('server', 'pidfile', str(options.run))
        pass
    if hasattr(options, 'syslog'):
        conf.set('log', 'syslog', str(options.syslog))
        pass
    if sys.platform == 'win32':
        if options.filelog and options.ntevent:
            parser.error(_('options -f and -e are mutually exclusive'))
            pass
        elif not (options.filelog or options.ntevent):
            # ログ記録オプションが設定されていない
            # pywin32を使えばサービス化できそうなので、可能になったらEventLogに記録する
            # それまではrootLoggerの規定値を使う
            #options.ntevent = True
            pass
        pass
    if sys.platform != 'win32':
        if options.filelog and options.syslog:
            parser.error(_('options -f and -s are mutually exclusive'))
            pass
        elif not (options.filelog or options.syslog):
            # ログ記録オプションが設定されていない
            # デーモン化しているため標準入出力がどこかへ行ってしまうので、syslogに記録させる
            options.syslog = True
            conf.set('log', 'syslog', options.syslog)
            pass
        pass
    return (options, args)

def readconfig():
    '''
    設定ファイル読み込み
    '''
    conf = ConfigParser.SafeConfigParser()
    conf.read('pysocialskkserv.cfg')
    return conf

class SocialSKKServer(SocketServer.ThreadingTCPServer):
    allow_reuse_address = True
    daemon_threads = True
    pass

class SocialSKKRequestHandler(SocketServer.StreamRequestHandler):
    VERSION = u'PySocialSKKServ0.5 '
    SERVER = u'http://www.social-ime.com:80/'
    CLIENT_END = u'0'
    CLIENT_REQUEST = u'1'
    CLIENT_VERSION = u'2'
    CLIENT_HOST = u'3'
    CLIENT_SERVER_COMPLETION = u'4'

    SERVER_ERROR = u'0'
    SERVER_FOUND = u'1'
    SERVER_NOT_FOUND = u'4'
    SERVER_FULL = u'9'

    COMBUFSIZE = 1024

    SERVER_CHARSET = 'EUC-JP'
    CLIENT_CHARSET = 'EUC-JP'

    specialbefore = u'/;#'
    specialafter = {
        u'/': u'\\057',
        u';': u'\\073',
        u'#': u'\\043',
        }
    specialxlat = None

    # str.isalnumだと「ひらがな」なども「アルファベット」扱いなので自作
    def isalnum(self, str):
        return isContentOnly(str, u'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ')

    def isHiragana(self, str):
        return isContentOnly(str, u'あいうえおぁぃぅぇぉかきくけこがぎぐげごさしすせそざじずぜぞたちつてとだぢづでどっなにぬねのはひふへほぱぴぷぺぽばびぶべぼまみむめもやゆよゃゅょらりるれろわゐゑをん')

    def isKatakana(self, str):
        return isContentOnly(str, u'アイウエオァィゥェォカキクケコガギグゲゴサシスセソザジズゼゾタチツテトダヂヅデドッナニヌネノハヒフヘホパピプペポバビブベボマミムメモヤユヨャュョラリルレロワヰヱヲン')

    def isKana(self, str):
        return isContentOnly(str, u'あいうえおぁぃぅぇぉかきくけこがぎぐげごさしすせそざじずぜぞたちつてとだぢづでどっなにぬねのはひふへほぱぴぷぺぽばびぶべぼまみむめもやゆよゃゅょらりるれろわゐゑをんアイウエオァィゥェォカキクケコガギグゲゴサシスセソザジズゼゾタチツテトダヂヅデドッナニヌネノハヒフヘホパピプペポバビブベボマミムメモヤユヨャュョラリルレロワヰヱヲン')

    # 変換の統計
    nRequest = 0
    nError = 0
    nOK = 0
    nFail = 0
    nPredict = 0
    nDict = 0

    okurimap = {
        u'a': u'あ',
        u'i': u'い',
        u'u': u'う',
        u'e': u'え',
        u'o': u'お',
        u'k': u'かきくけこ',
        u'g': u'がぎぐげご',
        u's': u'さしすせそ',
        u'z': u'ざじずぜぞ',
        u'j': u'じ',
        u't': u'たちつてとっ',
        u'd': u'だぢづでど',
        u'n': u'なにぬねのん',
        u'h': u'はひふへほ',
        u'p': u'ぱぴぷぺぽ',
        u'b': u'ばびぶべぼ',
        u'm': u'まみむめも',
        u'y': u'やゆよゃゅょ',
        u'r': u'らりるれろ',
        u'w': u'わゐうゑを',
        }
    
    # Social IME APIを呼び出して変換
    # 結果は配列で返す
    def convert(self, arg, predict):
        debug_method(_(u'convert %(arg)s, %(predict)s') % {'arg': arg, 'predict': predict})
        self.nRequest = self.nRequest + 1
        earg = arg.encode(self.SERVER_CHARSET)
        if predict:
            # 予測変換
            params = urllib.urlencode({'string': earg, 'charset': self.SERVER_CHARSET})
            request = self.SERVER+'api2/predict.php?%s' % params
            self.nPredict = self.nPredict + 1
            pass
        else:
            # 文節で変換
            params = urllib.urlencode({'string': earg, 'resize[0]': '+'+str(len(arg)), 'charset': self.SERVER_CHARSET})
            request = self.SERVER+'api/?%s' % params
            self.nDict = self.nDict + 1
            pass
        try:
            f = urllib.urlopen(request)
            result = f.read().strip()
            uresult = result.decode(self.SERVER_CHARSET)
            array = uresult.split(u'\t')
            debug_method(uresult)
            # 特殊文字対策
            newarray = []
            for x in array:
                if isContentAny(x, self.specialbefore):
                    r = u'(concat "%s")' % self.specialxlat(x)
                    pass
                else:
                    r = x
                    pass
                newarray.append(r)
                pass
            ret = newarray
            if ret:
                status = self.SERVER_FOUND
                pass
            else:
                status = self.SERVER_NOT_FOUND
                pass
        except IOError, e:
            debug_method(_('server error') + str(f.info()))
            ret = []
            status = self.SERVER_ERROR
            pass
        except:
            debug_method(_('unknown error') + str(f.info()))
            ret = []
            status = self.SERVER_ERROR
            pass
        return (status, ret)
    
    def do_0(self, arg):             # CLIENT_END
        debug_method(_('CLIENT_END:') + arg)
        self.close_connection = True
        return arg
    
    def do_1(self, arg):             # CLIENT_REQUEST
        '''
        通常のSKK変換要求を処理する
        「かな」のみまたは「英字」のみの場合は、要求された変換対象文字列を1文節として「かな漢字変換API」で変換する。
        「かな」+最後の文字が「英字」または「*」の場合に、要求された変換対象文字列全体を「予測変換API」で変換する。
        '''
        ## 予測変換フラグ
        predict = False
        ## 送りありフラグ
        okuri = ''
        # 送り仮名だったら予測変換
        # 全てASCII文字か日本語文字だったら文節変換
        if self.isalnum(arg):
            # 英単語っぽい？全て数字か英字のASCII文字
            predict = False
        else:
            if arg[-1] in u'abcdefgihjklmnopqrstuvwxyzABCDEFGIHJKLMNOPQRSTUVWXYZ*':
                # EBDIC backendでのワイルドカード変換と送り仮名ありのとき予測変換
                predict = True
                if arg[-1] == u'*':
                    # ワイルドカード文字は送り仮名ではない
                    pass
                else:
                    okuri = arg[-1]
                    pass
                arg = arg[:-1]
            else:
                # 送りなし
                predict = False
                pass
            pass
        (status, result) = self.convert(arg, predict)
        if status == self.SERVER_FOUND:
            if okuri:
                newresult = {}
                for r in result:
                    if r[-1] in self.okurimap[okuri]:
                        newresult[r[:-1]] = None
                        pass
                    pass
                if newresult:
                    ret = u'%s/%s/\n' %  (status, u'/'.join(newresult.keys()))
                    self.nOK = self.nOK + 1
                    pass
                else:
                    ret = u'%s/%s/\n' % (self.SERVER_NOT_FOUND, arg)
                    self.nFail = self.nFail + 1
                    pass
                pass
            else:
                ret = u'%s/%s/\n' %  (status, u'/'.join(result))
                self.nOK = self.nOK + 1
                pass
        else:
            ret = u'%s/%s/\n' % (status, arg)
            if status == self.SERVER_ERROR:
                self.nError = self.nError + 1
                pass
            else:
                self.nFail = self.nFail + 1
                pass
            pass
        return ret
    
    def do_2(self, arg):             # CLIENT_VERSION
        return self.VERSION
    
    def do_3(self, arg):             # CLIENT_HOST
        hostname = socket.gethostname()
        ipaddr = socket.gethostbyname(hostname)
        ret = u'%s:%s: ' % (hostname, ipaddr)
        return ret
    
    def do_4(self, arg):        # CLIENT_SERVER_COMPLETION
        lookup = False
        if arg[-1] == u'~':        # skk-lookup方式
            arg = arg[:-1]
            lookup = True
            pass
        # まずは予測変換させてみる
        (status, result) = self.convert(arg, True)
        if status == self.SERVER_FOUND:
            newresult = []
            if lookup:
                newresult = result
            else:
                for x in result:
                    if self.isHiragana(x):
                        newresult.append(x)
                        pass
                    pass
                pass
            if newresult:
                ret = u'%s %s \n' % (self.SERVER_FOUND, u' '.join(newresult))
                self.nOK = self.nOK + 1
            else:
                ret = u'%s %s \n' % (self.SERVER_NOT_FOUND, arg)
                self.nFail = self.nFail + 1
                pass
            pass
        else:
            ret = u'%s %s \n' % (status, arg)
            if status == self.SERVER_ERROR:
                self.nError = self.nError + 1
                pass
            else:
                self.nFail = self.nFail + 1
                pass
            pass
        return ret

    def do_UNKNOWN(self, arg):
        logging.warninng(_('unsupported command (%(arg)r)') % {'arg': arg})
        return self.SERVER_ERROR
    
    close_connection = False
    
    def handle_one_request(self):
        raw_request = self.connection.recv(self.COMBUFSIZE)
        if raw_request:
            try:
                urequest = raw_request.decode(self.CLIENT_CHARSET)
                mname = u'do_' + urequest[0]
                if not hasattr(self, mname):
                    self.do_UNKNOWN(urequest)
                    return
                method = getattr(self, mname)
                urequest = urequest.strip()
                uret = method(urequest[1:])
                ret = uret.encode(self.CLIENT_CHARSET)
            except:
                logging.exception(_('server error'))
                self.nError = self.nError + 1
                uret = self.SERVER_ERROR
                ret = uret.encode(self.CLIENT_CHARSET)
                pass
            debug_method(uret)
            self.connection.sendall(ret)
            pass
        else:
            self.close_connection = True
            pass
        return

    def handle(self):
        try:
            m = _('new connection %(client)s %(server)s\n') % {'client':self.client_address, 'server':self.server}
            logging.info(m)
            while not self.close_connection:
                try:
                    self.handle_one_request()
                except:
                    logging.exception(_('protocol handler error'))
                    self.close_connection = True
                    pass
                pass
            m = _('%(client)s request: %(req)d(%(dict)d/%(predict)d) error: %(error)d ok: %(ok)d fail: %(fail)d\n') % {'client':self.client_address, 'req':self.nRequest, 'dict':self.nDict, 'predict':self.nPredict, 'error':self.nError, 'ok':self.nOK, 'fail':self.nFail}
            logging.info(m)
            m = _('connection closed %(client)s %(server)s\n') % {'client':self.client_address, 'server':self.server}
            logging.info(m)
        except:
            logging.exception(_('PySocialSKKServ got exception'))
            pass
        return

    def setup(self):
        SocketServer.StreamRequestHandler.setup(self)
        # プロトコルハンドラループに突入する前に初期化すべき何かをここに記述
        self.specialxlat = buildTranslater(self.specialafter)
        pass

    def finish(self):
        SocketServer.StreamRequestHandler.finish(self)
        # その他にクリーンアップすべき何かがあれば、ここに記述
        pass

    pass                        # end of class

def daemonize(stdin='/dev/null', stdout='/dev/null', stderr='/dev/null', run='/dev/null'):
    '''
    デーモン化手続き
    Platform: UNIX
    '''
    # 1st fork
    try:
        pid = os.fork()
        if pid > 0:
            sys.exit(0)
            pass
        pass
    except OSError, (errno, errstr):
        logging.debug(_('1st fork failed: %s(%d)\n') % (errstr, errno))
        sys.exit(1)
        pass
 # separate from parent process
    os.chdir('/')
    os.umask(0)
    os.setsid()
        # 2nd fork
    try:
        pid = os.fork()
        if pid > 0:
            sys.exit(0)
            pass
        file(run, 'w').write(str(os.getpid()))
        pass
    except OSError, (errno, errstr):
        logging.debug(_('2nd fork failed: %s(%d)\n') % (errstr, errno))
        sys.exit(1)
        pass
        # daemonize complete
    for f in sys.stdout, sys.stderr:
        f.flush()
        pass
    si = open(stdin, 'r')
    so = open(stdout, 'a+', 0)
    se = open(stderr, 'a+', 0)
    os.dup2(si.fileno(), sys.stdin.fileno())
    os.dup2(so.fileno(), sys.stdout.fileno())
    os.dup2(se.fileno(), sys.stderr.fileno())
    return

if sys.platform == 'win32':
    import win32serviceutil, win32service, pywintypes
    class PySocialSKKServService(win32serviceutil.ServiceFramework):
        _svc_name_ = 'PySocialSKKServ'
        _svc_display_name_ = 'Social IME SKKServ Service (Python)'
        _svc_description_ = 'SKKServ Social IME WebAPI binding'

        __service = None
        __serving = True
        def __init__(self, args):
            win32serviceutil.ServiceFramework.__init__(self, args)
            (lang, encoding) = locale.getdefaultlocale()
            os.chdir(getMainDir())
            global _
            _ = gettext.translation('pysocialskkserv', '.', languages=[lang,]).ugettext
            global conf
            if not conf:
                conf = readconfig()
                pass
            setupLogger()
            logging.info(_('initializing PySocialSKKServ\n'))
            SocialSKKServer.daemon_threads = False
            self.__service = SocialSKKServer(('0.0.0.0', conf.getint('server', 'port')), SocialSKKRequestHandler)
            pass

        # サービスに対するコマンドに対応するルーチン群
        def SvcStop(self):
            logging.info(_('request PySocialSKKServ service stop\n'))
            self.ReportServiceStatus(win32service.SERVICE_STOP_PENDING)
            self.__serving = False
            # これを呼び出すことと、daemon_threadを無効にしているので、サーバー部分が終了し、SvcDoRunの無限ループから脱出が行われる。
            self.__service.server_close()
            pass

#         def SvcPause(self):
#             pass

#         def SvcContinue(self):
#             pass

#         def SvcInterrogate(self):
#             win32serviceutil.ServiceFramework.SvcInterrogate(self)
#             pass

#         def SvcShutdown(self):
#             pass

        # サービスの開始が要求されると呼び出されるっぽい
        def SvcDoRun(self):
            # これだだけと新規接続は受け付けなくなるが既に起動されたスレッドはそのまま
            logging.info(_('PySocialSKKServ service start\n'))
            while self.__serving:
                self.__service.handle_request()
                pass
            self.ReportServiceStatus(win32service.SERVICE_STOPPED)
            #logging.info(_('PySocialSKKServ service stopped\n'))
            pass
    pass

# PYTHONSERVICE.EXEで処理分けされている部分はPythonランタイムを導入している環境かつWindowsにてサービス化して利用する場合
# py2winで単にexeにする場合は__name__が__main__になるが、サービスとしてexeを作るとサービス用のclassが直接呼ばれるっぽい?
def isPy2exe():
    import imp
    return (hasattr(sys, 'frozen') or   # py2exe
            hasattr(sys, 'importers') or # py2exe old
            imp.is_frozen('__main__'))

def isService():
    return os.path.basename(sys.argv[0]).upper() == 'PYTHONSERVICE.EXE'

def getMainDir():
    p = sys.argv[0]
    if isPy2exe():
        p = sys.executable
        pass
    if isService():
        p = sys.path[-1]
        pass
    print p
    p = os.path.abspath(p)
    if not os.path.isdir(p):
        p = os.path.dirname(p)
        pass
    return p

def startSKKServer():
    logging.info(_('initializing PySocialSKKServ\n'))
    server = SocialSKKServer(('0.0.0.0', conf.getint('server', 'port')), SocialSKKRequestHandler)
    logging.info(_('PySocialSKKServ service start\n'))
    server.serve_forever()
    return

def main():
    # Pythonランタイム環境
    (lang, encoding) = locale.getdefaultlocale()
    # コンソールの実際のエンコーディングに設定する
    # PythonのバージョンによってはUnicodeErrorが出てしまう
    #sys.stdin = codecs.getreader(encoding)(sys.stdin)
    #sys.stdout = codecs.getwriter(encoding)(sys.stdout)
    #sys.stderr = codecs.getwriter(encoding)(sys.stderr)
    os.chdir(getMainDir())
    global _, conf
    _ = gettext.translation('pysocialskkserv', '.', languages=[lang,]).ugettext
    conf = readconfig()
    (options, args) = parseoptions()
    sys.argv[1:] = args
    setupLogger()
    if conf.getboolean('server', 'daemon') and not isPy2exe():
        logging.debug('start as daemon')
        if sys.platform == 'win32':
            try:
                if len(sys.argv) > 1:
                    err = win32serviceutil.HandleCommandLine(PySocialSKKServService)
                else:
                    err = win32serviceutil.StartService(PySocialSKKServService._svc_name_)
                    pass
                pass
            except pywintypes.error, (code, func, msg):
                err = code
                logging.exception('Service oriented error')
                pass
            sys.exit(err)
            pass
        else:
            daemonize(run=conf.get('server', 'pidfile'))
            startSKKServer()
            pass
        pass
    else:
        logging.debug('start on console')
        startSKKServer()
    pass
    
if __name__ == '__main__':
    main()
