from twisted.web import client, error
from twisted.internet import reactor
from twisted.python import failure
import gzip
import StringIO
import habu.log as log

class HTTPPageGetter(client.HTTPPageGetter):
    def handleStatus_301(self):
        l = self.headers.get('location')
        log.info("redirect localtion" + str(l))
        if not l:
            self.handleStatusDefault()
            return
        url = l[0]
        if self.followRedirect:
            scheme, host, port, path = \
               client. _parse(url, defaultPort=self.transport.getPeer().port)
            self.factory.setURL(url)
    
            if self.factory.scheme == 'https':
                from twisted.internet import ssl
                contextFactory = ssl.ClientContextFactory()
                reactor.connectSSL(self.factory.host, self.factory.port, 
                                   self.factory, contextFactory)
            else:
                if self.factory.proxy_host:
                    if not self.factory.proxy_port:
                        proxy_port = 80
                    reactor.connectTCP(self.factory.proxy_host, self.factory.proxy_port, self.factory)
                else:
                    reactor.connectTCP(self.factory.host, self.factory.port, 
                                       self.factory)
        else:
            self.handleStatusDefault()
            self.factory.noPage(
                failure.Failure(
                    error.PageRedirect(
                        self.status, self.message, location = url)))
        self.quietLoss = 1
        self.transport.loseConnection()

    handleStatus_302 = lambda self: self.handleStatus_301()


class HTTPClientFactory(client.HTTPClientFactory):
     protocol = HTTPPageGetter
     def __init__(self, url, method='GET', postdata=None, headers=None,
                 agent="Twisted PageGetter", timeout=0, cookies=None,
                 followRedirect=1, proxy_host = None, proxy_port = 80):
         if proxy_host:
             self.has_proxy = True
         else:
             self.has_proxy = False
         self.proxy_host = proxy_host
         self.proxy_port = proxy_port
         client.HTTPClientFactory.__init__(self, url, method, postdata, headers,
                                           agent, timeout, cookies,
                                           followRedirect)

     def setURL(self, url):
         client.HTTPClientFactory.setURL(self, url)
         if self.has_proxy:
             self.path = url

     def page(self, page):
         encoding = self.response_headers.get("content-encoding")
         if encoding:
             io = StringIO.StringIO(page)
             fp = gzip.GzipFile(fileobj = io)
             page = fp.read()
             fp.close()
         client.HTTPClientFactory.page(self, page)
         
             

def getPage(url, proxy_host = None, proxy_port = None,
            contextFactory = None, *args, **kwargs):
    log.info("habu.webutils.getPage : " + url)
    if proxy_host:
        log.debug("proxy host : " + proxy_host)
        log.debug("proxy port : " + str(proxy_port))
    scheme, host, port, path = client._parse(url)
    factory = HTTPClientFactory(url, proxy_host = proxy_host, proxy_port = proxy_port, *args, **kwargs)
    if scheme == 'https':
        from twisted.internet import ssl
        if contextFactory is None:
            contextFactory = ssl.ClientContextFactory()
        reactor.connectSSL(host, port, factory, contextFactory)
    else:
        if proxy_host:
            if not proxy_port:
                proxy_port = 80
            reactor.connectTCP(proxy_host, proxy_port, factory)
        else:
            reactor.connectTCP(host, port, factory)
    return factory.deferred
