import hyperestraier
import habu.log as log

def _logMsg(status, link):
    log.debug("heupdater link:" + link)
    log.info("heupdater update status: " + str(status))
    return status

class HyperEstraierUpdater:
    def __init__(self, config, environ):
        self.node = hyperestraier.Node(hyperestraier.AsynTransport())
        url = config.get("node")
        userid = config.get("userid", "admin")
        password = config.get("password", "admin")
        self.node.set_url(url)
        self.node.set_auth(userid, password)

    def execute(self, content):
        self.running_tasks = [ self._update(entry)
                               for entry in content["entries"] ]
        
        return content

    def _update(self, entry):
        doc = hyperestraier.Document()
        doc.add_attr("@uri", entry["link"])
        doc.add_attr("@title", entry["title"])
        doc.add_text(entry["summary"])
        deferred = self.node.put_doc(doc)
        deferred.addCallback(_logMsg, entry["link"])

        return deferred


def create(config, environ):
    return HyperEstraierUpdater(config, environ)


if __name__ == "__main__":
    obj = create({"node": "http://localhost:1978/node/test",
                  "userid": "admin",
                  "password": "admin"}, None)
    content = {"entries":[{"title": u"hoge",
                           "link": u"http://localhost/test",
                           "summary": u"Hello, \n my world."}]}
    obj.execute(content)
    from twisted.internet import reactor
    reactor.run()
