import re

class Subs(object):
    def __init__(self, config, environ):
        self.config = config

    def execute(self, content):
        for entry in content["entries"]:
            for item in self.config:
                key = item["key"]
                regex = item["re"].decode("utf-8")
                to = item["to"].decode("utf-8")
                s = entry.get(key, "")
                s = re.sub(regex, to, s)
                entry[key] = s
        
        return content



def create(config, environ):
    return Subs(config, environ)
