from twisted.trial.unittest import TestCase

import habudb

class DbTest(TestCase):
    def setUp(self):
        if not habudb.isAvailable():
            habudb.initialize("sqlite:///memory")
        habudb.clearAll()

    def tearDown(self):
        habudb.clearAll()
        
    def testInitialize(self):
        if not habudb.isAvailable():
            habudb.initialize("sqlite:///memory")
            self.assertEquals(habudb.isAvailable(), True)
        self.assertRaises(habudb.HabuDatabaseError, 
                          habudb.initialize, "sqlite:///memory")

    def testNormal(self):
        content = {"feed": {"title": "feed1",
                            "link": "http://localhost/feed1",
                            "author": "feed1 author"},
                   "entries": [{"title": "feed1 title1",
                                "link": "http://localhost/feed1/1",
                                "author": "feed1 entry1 author",
                                "summary": "summary 1"},
                               {"title": "feed1 title2",
                                "link": "http://localhost/feed1/2",
                                "summary": "summary 2",
                                "summary_detail": {"type": "text/html",
                                                   "value": "summary detail 2"}},
                               ]
                   }
        
        habudb.updateEntries(content)
        entry = habudb.selectEntryByUrl("http://localhost/feed1/1")
        self.assertEquals(entry.title, "feed1 title1")
        self.assertEquals(entry.format, "text/plain")
        self.assertEquals(entry.summary, "summary 1")
        self.assertEquals(entry.author, "feed1 entry1 author")
        
        entry = habudb.selectEntryByUrl("http://localhost/feed1/2")
        self.assertEquals(entry.title, "feed1 title2")
        self.assertEquals(entry.format, "text/html")
        self.assertEquals(entry.summary, "summary detail 2")
        self.assertEquals(entry.author, "feed1 author")

        habudb.updateEntries(content)
        entry = habudb.selectEntryByUrl("http://localhost/feed1/1")
        self.assertEquals(entry.title, "feed1 title1")
        self.assertEquals(entry.format, "text/plain")
        self.assertEquals(entry.summary, "summary 1")
        
        entry = habudb.selectEntryByUrl("http://localhost/feed1/2")
        self.assertEquals(entry.title, "feed1 title2")
        self.assertEquals(entry.format, "text/html")
        self.assertEquals(entry.summary, "summary detail 2")

        content = {"feed": {"title": "feed2",
                            "link": "http://localhost/feed2"},
                   "entries": [{"title": "feed2 title2",
                                "link": "http://localhost/feed2/1",
                                "summary": "summary 1"},
                               {"title": "feed2 title2",
                                "link": "http://localhost/feed2/2",
                                "summary": "summary 2",
                                "summary_detail": {"type": "text/html",
                                                   "value": "summary detail 2"}},
                               ]
                   }
        
        habudb.updateEntries(content)
        self.assertEquals(habudb.Entry.select().count(), 4)
        self.assertEquals(habudb.Feed.select().count(), 2)
        
        
