from twisted.internet import defer
import habu.log as log

import pkg_resources
pkg_resources.require("TurboGears")
from turbogears import update_config


class FileInfo(object):
    def __init__(self, info):
        self.file = info["value"]
        self.type = info["type"]
        self.filename = info["title"]
        
class TmikiMoblogPublisher(object):
    def __init__(self, config, environ):
        self.config = config
        self.environ = environ
        self.blog_path = config.get("blog")
        
    def execute(self, content):
        update_config(configfile=self.config.setdefault("cfg_file", "dev.cfg"),
                      modulename="tmiki.config")
        try:
            from tmiki import model
            model.hub.hub.begin()
            for entry in content["entries"]:
                self._insert(model, entry)
        except Exception, e:
            log.error()
            model.hub.hub.rollback()
        else:
            log.info("tmikimoblog : commit")
            model.hub.hub.commit()
        model.hub.hub.end()
        return content
        

        
            

    def _insert(self, model, entry):
        media_path = []
        author_id = self.config.get("author_id", 1)
        for attachment in entry["file"]:
            filename = attachment["title"].split("/")[-1]
            filename = filename.split("\\")[-1]
            if attachment["type"].startswith("image/"):
                path = self.blog_path + "/images/" + filename
            else:
                path = self.blog_path + "/stuff/" + filename
            path = model.slugExt(path, 0)
            f = model.File(name = path, title = filename,
                           format = attachment["type"], type = "File",
                           author = author_id, description = "",
                           status = "visible")
            f.saveFile(FileInfo(attachment))
            media_path.append(f.name)
        blogName = self.blog_path + "/moblog"
        blogName = model.slug(blogName, 0)
        blog = model.BlogEntry(name = blogName,
                               type = "BlogEntry",
                               title = entry["title"], author = author_id,
                               body = entry["summary"], description = entry["summary"],
                               blog = model.Blog.byName(self.blog_path),
                               format = "text/plain",
                               status = "public")
        blog.resetTags("diary")
        blog.resetRelatedEntry(media_path)
                
        

def create(config, environ):
    return TmikiMoblogPublisher(config, environ)
