from twisted.trial.unittest import TestCase
import rssfeeder


class RssFeederTest(TestCase):
    def setUp(self):
        self.publisher = rssfeeder.create(
            {"title": "test",
             "link": "http://localhost/",
             "file": "/tmp/out.rss"}, None)

    def test_escapedstr(self):
        content = {"entries": [
                {"title": u"my title<>&='",
                 "updated": u"2007-02-20T18:16:02Z",
                 "link": u"http://localhost/somewhere",
                 "summary": u"Hello, World"},
                ]}
        self.publisher.execute(content)
        fp = open("/tmp/out.rss")
        rss = fp.read()
        fp.close()
        self.assertEquals(rss.find("my title<>&='"), -1)
        self.assertNotEquals(rss.find("<title>my title&lt;&gt;&amp;='</title>"), -1)


    def test_nodate(self):
        content = {
            "entries": [
                {"title": u"my title<>&='",
                 "link": u"http://localhost/somewhere",
                 "summary": u"Hello, World"},
                ]}
        self.publisher.execute(content)
        fp = open("/tmp/out.rss")
        rss = fp.read()
        fp.close()
        self.assertNotEquals(rss.find("<updated>"), -1)


