import imp
import os
import os.path
from habu.webutils import getPage

_moduleFactories = {}

def loadModuleFromNet(moduleName, configPluginPath = [],
                      url = None,
                      proxy_host = None, proxy_port = 0):
    try:
        return loadModule(moduleName, configPluginPath)
    except ImportError, e:
        if not url:
            raise e
        def gotSuccess(result):
            return loadModule(moduleName, configPluginPath)
        
        deferred = downloadModule(url, moduleName, configPluginPath[0],
                                  proxy_host, proxy_port)
        deferred.addCallback(gotSuccess)
        return deferred
        

def loadModule(moduleName, configPluginPath = []):
    if _moduleFactories.has_key(moduleName):
        return _moduleFactories[moduleName]

    basepath, name = moduleName.rsplit(".", 1)
    basepath = basepath.replace(".", "/")

    plugin_path = [os.path.join(dirname, basepath) for dirname 
                   in configPluginPath]
    modinfo = imp.find_module(name, plugin_path)
    mod = imp.load_module(name, *modinfo)
    _moduleFactories[moduleName] = mod

    return mod



def downloadModule(url, moduleName, pluginDir,
                   proxy_host=None, proxy_port=0):
    if url[-1] != "/":
        url += "/"
    moduleName = moduleName.replace(".", "/")
    url = "%s%s.py" % (url, moduleName)

    def saveModule(result):
        path = os.path.join(pluginDir, moduleName) + ".py"
        dirname = os.path.dirname(path)
        if not os.path.exists(dirname):
            os.makedirs(dirname)
        fp = open(path, "w")
        fp.write(result)
        fp.close()
        return result
    
    return getPage(url, proxy_host, proxy_port).addCallback(
        saveModule)
    
