import habu.habuutils
import re

def makeFunc(expr):
    def evalExpr(entry):
        return eval(expr, {"entry": entry})
    
    return evalExpr


MAP_EXPR_FUNC = {
    "str": lambda expr: expr,
    "re": lambda expr: re.compile(expr, re.MULTILINE),
    "eval": makeFunc
    }

class Grep:
    def __init__(self, config, environ):
        condition = self.getCondition(config)
        exclusive = config.get("exclusive", False)
        self.filter = habu.habuutils.Grep(exclusive=exclusive, **condition)
    
    def getCondition(self, config):
        condition = {}
        for exprKey, exprFunc in MAP_EXPR_FUNC.iteritems():
            for key, value in config.get(exprKey, {}).iteritems():
                condition[key] = exprFunc(value)

        return condition

    def execute(self, content):
        content["entries"] = [ entry for entry in 
                               self.filter.iterEntries(content) ]
        
        return content


def create(config, environ):
    return Grep(config, environ)
