
import habu.log as log

class TitleFormatter:
    def __init__(self, config, environ):
        self.formatter = config.get("format", "%(title)s")
        
    def execute(self, content):
        feed = content["feed"]
        for entry in content["entries"]:
            copied = entry.copy()
            for k,v in feed.iteritems():
                copied["feed." + k] = v
            entry["title"] = self.formatter % copied
            
        return content


def create(config, environ):
    return TitleFormatter(config, environ)
