from twisted.web import client
from twisted.internet import reactor
import habu.log as log

class HTTPClientFactory(client.HTTPClientFactory):
     def __init__(self, url, method='GET', postdata=None, headers=None,
                 agent="Twisted PageGetter", timeout=0, cookies=None,
                 followRedirect=1, proxy_host = None, proxy_port = 80):
         if proxy_host:
             self.has_proxy = True
         else:
             self.has_proxy = False
         self.proxy_host = proxy_host
         self.proxy_port = proxy_port
         client.HTTPClientFactory.__init__(self, url, method, postdata, headers,
                                           agent, timeout, cookies,
                                           followRedirect)

     def setURL(self, url):
         client.HTTPClientFactory.setURL(self, url)
         if self.has_proxy:
             self.path = url
         log.debug(self.path)


def getPage(url, proxy_host = None, proxy_port = None,
            contextFactory = None, *args, **kwargs):
    log.info("habu.webutils.getPage : " + url)
    if proxy_host:
        log.debug("proxy host : " + proxy_host)
        log.debug("proxy port : " + str(proxy_port))
    scheme, host, port, path = client._parse(url)
    factory = HTTPClientFactory(url, proxy_host = proxy_host, proxy_port = proxy_port, *args, **kwargs)
    if scheme == 'https':
        from twisted.internet import ssl
        if contextFactory is None:
            contextFactory = ssl.ClientContextFactory()
        reactor.connectSSL(host, port, factory, contextFactory)
    else:
        if proxy_host:
            if not proxy_port:
                proxy_port = 80
            reactor.connectTCP(proxy_host, proxy_port, factory)
        else:
            reactor.connectTCP(host, port, factory)
    return factory.deferred
