# subscription by config
from twisted.internet import reactor
from twisted.internet.defer import Deferred
from habu.webutils import getPage

class CustomFeed(object):
    def __init__(self, config, environ):
        self.config = config
        self.deferred = None
        self.proxy_host = environ.get("proxy_host", None)
        self.proxy_port = environ.get("proxy_port", 0)
        
    def execute(self, content=None):
        url = self.config["url"]
        return getPage(url, self.proxy_host, self.proxy_port).addCallback(
            self.gotPage).addErrback(
            self.gotErr)

    def gotErr(self, failure):
        self.deferred.errback(failure)

    def gotPage(self, content):
        body = ""
        capture = self.config.get("capture", None)
        if capture:
            matched = re.findall(capture, content, re.MULTILINE)
            if matched:
                body = matched[0]
        else:
            body = content

        splitter = self.config.get("split", None)
        if splitter:
            items = [{"summary": s} for s in re.split(splitter, body) if s]
        else:
            items = [{"summary":body}]

        reTitle = self.config.get("title", "(.*)")
        for item in items:
            matched = re.findall(reTitle, item["summary"], re.MULTILINE)
            if matched:
                item["title"] = matched[0]
            else:
                item["title"] = item["summary"][:40]
        
        # TODO: find date

        reLink = self.config.get("link", "#")
        for item in items:
            item["link"] = reLink

        return dict(entries=item)


def create(config, environ):
    return CustomFeed(config, environ)
