
from twisted.internet import reactor

class HabuServer(object):
    def __init__(self, port, factory, addr = "localhost"):
        self.addr = addr
        self.port = port
        self.factory = factory

    def start(self):
        reactor.listenTCP(self.port, self.factory, interface=self.addr)

def setupWeb(config):
    from habu.server import habuweb
    factory = habuweb.createServerFactory(config)
    serverConfig = config.get("config", None)
    if not serverConfig:
        return None
    
    addr = serverConfig.get("interface", "localhost")
    port = serverConfig.get("port", 0)
    if not factory or not port:
        return None
    
    return HabuServer(port, factory, addr)



HABU_SERVER_SETUP_FACTORY_TAB = {
    "web": setupWeb,
    }
