from habu.habuutils import dumpRSS


class RssFeeder(object):
    def __init__(self, config, environ):
        self.data = {}
        self.feed = {"title": config.get("title", "Habu RSS"),
                     "link":config.get("link", "http://localhost/")
                     }
        self.out_path = config.get("file", "./rss")
        self.format = config.get("format", "atom1.0")
        
    def execute(self, content):
        allEntries = self.data.setdefault("entries", [])
        allEntries.extend(content.get("entries", []))
        self._dump()
        
        return content
        
    def _dump(self):
        f = open(self.out_path, "w")
        self.data["feed"] = self.feed
        dumpRSS(self.data, f, self.format)
        f.close()        

def create(config, environ):
    return RssFeeder(config, environ)
