from twisted.python import log as logger

NONE     = 0
CRITICAL = 10
FATAL    = 20
ERROR    = 30
WARN     = 40
INFO     = 50
DEBUG    = 60


_level = INFO
_initialized = False

def startLogging(logFile, level=INFO):
    global _level
    global _initialized
    if isinstance(level, str):
        try:
            level = eval(level)
            if not isinstance(level, int):
                level = INFO
        except:
            level = INFO
    _level = level
    _initialized = True
    logger.startLogging(logFile)


def critical(*args, **kwds):
    log(CRITICAL, *args, **kwds)

def fatal(*args, **kwds):
    log(FATAL,*args, **kwds)

def error(*args, **kwds):
    log(ERROR,*args, **kwds)

def warn(*args, **kwds):
    log(WARN, *args, **kwds)

def info(*args, **kwds):
    log(INFO,*args, **kwds)

def debug(*args, **kwds):
    log(DEBUG,*args, **kwds)

def log(level, *args, **kwds):
    if not _initialized:
        print args[0]
    elif _level >= level:
        if level > ERROR:
            logger.msg(*args, **kwds)
        else:
            logger.err(*args, **kwds)
