import anydbm
import datetime
from feedparser import _parse_date

def dbdatefixer(url):
    try:
        from habu import habudb
        if habudb.isAvailable():
            entry = habudb.selectEntryByUrl(url)
            if entry:
                return entry.updated.timetuple()
    except:
        pass
    return datefixer(url)

def datefixer(url):
    return datetime.datetime.now().timetuple()

class AdjustDate:
    def __init__(self, config, environ):
        self.datefiexer = config.get("use_db", False) and dbdatefixer or datefixer

    def execute(self, content):
        n = datetime.datetime.now()
        now = n.timetuple()
        nStr = str(n)
        for entry in content["entries"]:
            updated = entry.get("updated", None)
            parsed_updated = entry.get("updated_parsed", None)
            
            if updated and not parsed_updated:
                parsed_updated = _parse_date(updated)
            elif not parsed_updated:
                parsed_updated = now

            entry["updated_parsed"] = parsed_updated
            entry["updated"] = self.date2str(parsed_updated)

        return content

    def date2str(self, dt):
        return "%d-%02d-%02dT%02d:%02d:%02dZ" % dt[:6]


def create(config, environ):
    return AdjustDate(config, environ)
