from twisted.python import log
from twisted.internet import reactor, threads
from twisted.internet.defer import Deferred

import feedparser
import mixi2rss


class MixiRss(object):
    def __init__(self, config, environ):
        self.config = config
        self.userid = config["userid"]
        self.password = config["password"]

    def fetch(self):
        xml =  mixi2rss.mixi2rss(self.userid, self.password, "new_friend_diary")
        return feedparser.parse(xml)

    def gotRSS(self, result, deferred):
        deferred.callback(result)
        return result

    def gotErr(self, failure, deferred):
        deferred.errback(failure)
        

    def execute(self, cotent):
        deferred = Deferred()
        threads.deferToThread(self.fetch).addCallback(
            self.gotRSS, deferred).addErrback(
            self.gotErr, deferred)
        
        return deferred


def create(config, environ):
    return MixiRss(config, environ)
