
from twisted.internet import reactor
from twisted.internet.defer import Deferred
from twisted.python import log

import time

SCHEDULE_INTERVAL = 60

class Cron(object):
    def __init__(self):
        self.crontab = []

    def add(self, expr, func, *args, **kwds):
        if not callable(func):
            raise
        self.crontab.append((expr, func, args, kwds))

    def start(self):
        log.msg("cron : start")
        reactor.callLater(self.nextTime() - time.time(), self._start)

    def _start(self):
        nextSchedule = self.nextTime()
        currentTime = time.time()
        value = time.localtime(nextSchedule)
        for item in self.crontab:
            if self.matchAll(value, item[0]):
                args = item[2] != None and item[2] or []
                kwds = item[3] != None and item[3] or {}
                log.msg("cron : execute")
                item[1](*args, **kwds)

        reactor.callLater(nextSchedule - time.time(),
                          self._start)

    def matchWild(self, value, expr):
        if expr == "*":
            return True
        if expr.startswith("*/"):
            i = int(expr[2:])
            return value % i == 0
        return False

    def match(self, value, expr):
        if "*" in expr:
            return self.matchWild(value, expr)
        
        return str(value) in expr.split(",")
    
    def matchAll(self, value, expr):
        for index in range(4, 0, -1):
            v = value[index]
            e = expr[4 - index]
            if not self.match(v, e):
                return False
        weekday = (value[6] + 1) % 7
        return self.match(weekday, expr[4])
    
    def nextTime(self):
        nt = time.localtime(time.time()+SCHEDULE_INTERVAL)
        nt  = nt[:5] + (0,) + nt[6:]
        return time.mktime(nt)


_EXPRESSION_REPR = {
    "hourly": "0 * * * *",
    "daily": "0 2 * * *",
    "weekly": "0 0 0 0 1",
    "monthly": "0 0 1 * *"
    }

def parseExpression(expression):
    if _EXPRESSION_REPR.has_key(expression):
        expression = _EXPRESSION_REPR[expression]
    return expression.split(" ")
