from twisted.internet import reactor
from twisted.python import log
import habu

import sys

def usage(name):
    print "Usage : %s [options] [config_file_path]" % name
    print "Valid Options:\n" \
        "    -h, --help: Show this message.\n" \
        "    -t, --target=TARGET_PIPELINE: Run specific pipeline.\n"
    sys.exit(0)


def parseArgs(args):
    from getopt import gnu_getopt
    import os.path
    
    try:
        options, arguments = gnu_getopt(args[1:], "ht:", ["help", "target="])
    except:
        usage(args[0])
    
    cfgFile = "habu.cfg"
    if arguments:
        cfgFile = arguments[0]
    if not os.path.exists(cfgFile):
        usage(args[0])

    target = None
    for opt, arg in options:
        if opt in ("-h", "--help"):
            usage(args[0])
        elif opt in ("-t", "--target"):
            target = arg
    
    return cfgFile, target

def main(*args):
    cfgFile, target = parseArgs(args)

    mgr = habu.Habu()
    mgr.load(open(cfgFile).read())
    
    if not mgr.getPipelines():
        print "No pipeline is defined"
        sys.exit(1)
    
    if not mgr.scheduler or target:
        if target != None:
            if target not in mgr.getPipelineNames():
                print "No target : %s" % target
                sys.exit(1)
            allManagers = [mgr.run(target)]
        else:
            allManagers = mgr.runAll()
        
        def eventFired(firedManager):
            if firedManager.executeContexts:
                return
            allManagers.remove(firedManager)
            if not allManagers:
                log.msg("Stopping reactor")
                reactor.stop()

        for m in allManagers:
            m.addHook(m.HOOK_TYPE_SUCCESS, eventFired)
            m.addHook(m.HOOK_TYPE_GOT_ERROR, eventFired)
        mode = "Task Mode"
    else:
        mgr.startScheduler()
        mode = "Scheduler Mode"

    mgr.startLogging()
    print "Started habu with " + mode
    
    reactor.run()
    

if __name__ == "__main__":
    main(*(sys.argv))
