# subscription by config
import sets
from twisted.python import log
from twisted.internet import reactor
from twisted.internet.defer import Deferred
from twisted.web.client import getPage
from habu import habuutils
import feedparser


class FeedConfig(object):
    def __init__(self, feedConfig):
        self.feedList = feedConfig
    
    def fetch(self):
        return self.feedList

class FileConfig(object):
    def __init__(self, filePath):
        self.path = filePath

    def fetch(self):
        lines = open(self.path).readlines()
        return [ l.strip() for l in lines]

class OpmlConfig(object):
    def __init__(self, conf):
        pass

    def fetch(self):
        return []

class Config(object):
    def __init__(self, config, environ):
        self.subModules = []
        self.fetchConfigs = []
        feedConfig = config.setdefault("feed", [])[:]
        if feedConfig:
            self.fetchConfigs.append(FeedConfig(feedConfig))
        feedConfig = config.setdefault("file", None)
        if feedConfig:
            self.fetchConfigss.append(FileConfig(feedConfig))
        self.maxThread = config.setdefault("max-thread", 0)

    def setSubModules(self, subModules):
        self.subModules = subModules
        
    def execute(self, content=None):
        feeds = []
        for config in self.fetchConfigs:
            feeds.extend(config.fetch())
        self.feed = sets.Set(feeds)
        try:
            self.feed.remove('')
        except:
            pass

        self.deferredList = [Deferred()  for f in self.feed]

        maxThread = min(
            self.maxThread > 0 and self.maxThread or len(self.feed),
            len(self.feed))

        for i in range(0, maxThread):
            url = self.feed.pop()
            getPage(url).addCallback(
                self.gotPage).addErrback(
                self.gotErr)

        result = self.deferredList[:]
        result = habuutils.mergeResult(result, self.subModules)

        return result

    def gotErr(self, failure):
        deferred = self.deferredList.pop()
        deferred.errback(failure)

    def gotPage(self, content):
        feed = feedparser.parse(content)
        if self.feed != None:
            deferred = self.deferredList.pop()
            deferred.callback(feed)
            if self.feed:
                url = self.feed.pop()
                log.msg("subscription.config : Next Feed Fetcher Start")
                getPage(url).addCallback(
                    self.gotPage).addErrback(
                    self.gotErr)
        else:
            deferred = self.deferredList.pop()
            deferred.errback("tmiki.subscription.config: parse failed")

        return content


def create(config, environ):
    return Config(config, environ)
