import hyperestraier
from twisted.python import log

def _logMsg(status, link):
    log.msg("heupdater link:" + link)
    log.msg("heupdater update status: " + str(status))

class HyperEstraierUpdater:
    def __init__(self, config, environ):
        self.node = hyperestraier.Node(hyperestraier.AsynTransport())
        url = config.get("node")
        userid = config.get("userid", "admin")
        password = config.get("password", "admin")
        self.node.set_url(url)
        self.node.set_auth(userid, password)

    def execute(self, content):
        for entry in content["entries"]:
            self._update(entry)
        return content

    def _update(self, entry):
        doc = hyperestraier.Document()
        doc.add_attr("@uri", entry["link"])
        doc.add_attr("@title", entry["title"])
        doc.add_text(entry["summary"])
        deferred = self.node.put_doc(doc)
        deferred.addCallback(_logMsg, entry["link"])


def create(config, environ):
    return HyperEstraierUpdater(config, environ)


if __name__ == "__main__":
    obj = create({"node": "http://localhost:1978/node/test",
                  "userid": "admin",
                  "password": "admin"}, None)
    content = {"entries":[{"title": u"hoge",
                           "link": u"http://localhost/test",
                           "summary": u"Hello, \n my world."}]}
    obj.execute(content)
    from twisted.internet import reactor
    reactor.run()
