<?php
// props, MVC style web application framework
//
// Copyright (C) Haruki Setoyama <props@planewave.org>
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
// $Id: Request.php,v 1.3 2003/06/14 10:35:56 haruki Exp $
/**
* props, MVC style web application framework
*
* @author Haruki Setoyama  <props@planewave.org>
* @package props
**/
/**
* propsRequest, User request handler like GET, POST value
*
* @access public
**/
class propsRequest {

    var $_magic_quotes;

    function propsRequest()
    {
        $this->form = new propsForm;
        $this->_magic_quotes = get_magic_quotes_gpc();
    }

    /**
    * get a user request value
    * @access public
    * @param string $name
    * @param string $type   G,P,F,C for GET, POST, FILES, COOKIE
    * @return mixed
    */
    function getParameter($name, $type='GP')
    {
        if(isset($this->filter[$name]))
        {
            return $this->filter[$name]->filter($this->getRawParameter($name, $type));
        }
        else
        {
            return $this->getRawParameter($name, $type);
        }
    }

    /**
    * getRawParameter
    * @access public
    * @return mixed
    **/
    function getRawParameter($name, $type='GP')
    {
        if($this->form->getValue($name) !== false)
        {
            return $this->form->getValue($name);
        }

        for($i=strlen($type)-1; $i>=0; $i--){
            switch($type[$i]){
            case 'G':
                if(isset($_GET[$name]))
                    return $this->_stripslashes($_GET[$name]);
                break;
            case 'P':
                if(isset($_POST[$name]))
                    return $this->_stripslashes($_POST[$name]);
                break;
            case 'F':
                if(isset($_FILES[$name]))
                    return $this->_stripslashes($_FILES[$name]);
                break;
            case 'C':
                 if(isset($_COOKIE[$name]))
                    return $this->_stripslashes($_COOKIE[$name]);
                break;
            default:
                // do nothing
            }
        }

        return false;
    }

    /**
    * get names of the user request values
    * @access public
    * @param string $type   G,P,F,C for GET, POST, FILES, COOKIE
    * @return array
    */
    function getParameterNames($type='GP')
    {
        $ret = $this->form->getValueNames();
        for($i=strlen($type)-1; $i>=0; $i--){
            switch($type[$i]){
            case 'G':
                $ret = array_merge($ret, array_keys($_GET));
                break;
            case 'P':
                $ret = array_merge($ret, array_keys($_POST));
                break;
            case 'F':
                $ret = array_merge($ret, array_keys($_FILES));
                break;
            case 'C':
                $ret = array_merge($ret, array_keys($_COOKIE));
                break;
            default:
                // do nothing
            }
        }
        return $ret;
    }

    //// propsRequestFilter
    var $filter = array();

    function setFilter($param_name, $filter)
    {
        $this->filer[$param_name] = $filter;
    }

    ///// propsForm
    var $form;

    function setForm(&$form, $command ='')
    {
        $this->form =& $form;
        $this->form->setValues($this, $command);
    }

    function validate($command ='')
    {
        return $this->form->validate($command);
    }

    function getError($name)
    {
        return $this->form->getError($name);
    }

    function getErrorNames()
    {
        return $this->form->getErrorNames();
    }

    /////

    function getCookie($name)
    {
        if(isset($_COOKIE[$name]))
            return $this->_stripslashes($_COOKIE[$name]);
        else
            return false;
        break;
    }

    function getEnvVar($name)
    {
       if(isset($_ENV[$name]))
            return $_ENV[$name];
        else
            return false;
    }

    function getServerVar($name)
    {
       if(isset($_SERVER[$name]))
            return $_SERVER[$name];
        else
            return false;
    }


    /////

    var $attribute = array();

    function getAttribute($name)
    {
        if(isset($this->attribute[$key])){
            return $this->attribute[$key];
        }else{
            return false;
        }
    }

    function getAttributeNames()
    {
        return array_keys($this->attribute);
    }

    function setAttribute($name, $value)
    {
        $this->attribute[$name] = $value;
    }

    ///////////////// TODO: below

    function getUri($site_root=''){
        if($site_root == ''){
            return $this->getEnvVar('HTTP_HOST').$this->getEnvVar('REQUEST_URI');
        }else{
            $uri = $this->getEnvVar('HTTP_HOST').$this->getEnvVar('REQUEST_URI');
            if(preg_match('/^'.$site_root.'/i', $uri)){
                return preg_replace('/^'.$site_root.'/i', '', $uri);
            }else{
                return false;
            }
        }
    }

    function isSecure(){
        return ($this->server_vars['HTTPS'] == 'on');
    }

    /////

    function _stripslashes($str)
    {
        if($this->_magic_quotes)
        {
            if (is_array($str)){
                $this->_stripslashes_array_($str);
                return $str;
            }else{
                return stripslashes($str);
            }
        }
        else
        {
            return $str;
        }
     }

     function _stripslashes_array_(&$array)
     {
        while (list($key) = each($array)) {
            if (is_array($array[$key])) {
                $this->_stripslashes_array_($array[$key]);
            } else {
                $array[$key] = stripslashes($array[$key]);
            }
        }
     }
}

///////////////////////////////////////////////////////////

/**
* propsRequestFilter
* @access interface
**/
class propsRequestFilter
{
    function filter($value)
    {
        return $value;
    }
}

/**
* propsRequestFilter for integer
* @access public
**/
class propsRequestFilter_int extends propsRequestFilter
{
    function filter($value)
    {
        return intval($value);
    }
}

/**
* propsRequestFilter for default value setting
* @access public
**/
class propsRequestFilter_default extends propsRequestFilter
{
    var $val;

    function propsRequestFilter_default($val)
    {
        $this->val = $val;
    }

    function filter($value)
    {
        if(strlen($value) > 0) return $value;
        else $this->val;
    }
}
?>