<?php
/**
 * PingBackT[rX
 *
 * @package   PukiWiki
 * @access    public
 * @author    Logue <logue@hotmail.co.jp>
 * @copyright 2012-2014 PukiWiki Advance Developers Team
 * @create    2014/02/27
 * @license   GPL v2 or (at your option) any later version
 * @version   $Id: PingBackService.php,v 1.0.1 2014/02/27 16:54:00 Logue Exp $
 */

namespace PukiWiki\Service;

use PukiWiki\Factory;
use PukiWiki\File\PingBackFile;
use Zend\Http\Client;
use Zend\Uri\Uri;

class PingBack{
	/**
	 * Mɐ
	 */
	const RESPONSE_SUCCESS                  = -1;
	/**
	 * MɎs
	 */
	const RESPONSE_FAULT_GENERIC            = 0;
	/**
	 * \[XURIȂ
	 */
	const RESPONSE_FAULT_SOURCE             = 0x0010;
	/**
	 * \[XɃ^[Qbg̃N݂Ȃ
	 */
	const RESPONSE_FAULT_SOURCE_LINK        = 0x0011;
	/**
	 * ^[QbgURIȂ
	 */
	const RESPONSE_FAULT_TARGET             = 0x0020;
	/**
	 * ^[QbgURIł
	 */
	const RESPONSE_FAULT_TARGET_INVALID     = 0x0021;
	/**
	 * łɓo^Ă
	 */
	const RESPONSE_FAULT_ALREADY_REGISTERED = 0x0030;
	/**
	 * ANZX
	 */
	const RESPONSE_FAULT_ACCESS_DENIED      = 0x0031;
	/**
	 * NGXgꂽeȂ
	 */
	const RESPONSE_FAULT_CONNECT            = 0x0032;
	/**
	 * ^CgȂꍇ̖O
	 */
	const UNTITLED_TITLE = 'Untitled';
	/**
	 * Pingback
	 *
	 * @param string $source y[WPingMp̃AhX
	 * @param string $target y[WPingҎp̃AhX
	 * @return int
	 */
	public function ping($source, $target) {
		// Zend\Uri\UriIuWFNg𐶐
		$source_url = Uri::factory($source);
		$target_url = Uri::factory($target);
		
		// ȃAhX
		if (!$target_url->isValid()){
			return self::RESPONSE_FAULT_TARGET_INVALID;
		}
		if (!$source_url->isValid()){
			return self::RESPONSE_FAULT_GENERIC;
		}

		if ($target_url->getHost() === $source_url->getHost()){
			// ^[Qbgƃ\[X̃zXgꏏ
			// TODO: hC̃TCg̏ꍇATCgƂ݂Ȃ
			return self::RESPONSE_FAULT_SOURCE;
		}

		// ̃TCgɐڑ
		$source_client = new Client($source_url);
		$source_response = $source_client->request(Client::GET);

		// ڑł`FbN
		if (!$source_response->isSuccessful()) {
			return self::RESPONSE_FAULT_SOURCE;
		}

		// ̃TCg̒g擾
		$source_body = $source_response->getBody();
		
		// g擾łȂ
		if (!$source_body){
			return self::RESPONSE_FAULT_SOURCE;
		}

		if ($target_url->getHost() !== $source_url->getHost() && (strpos($source_body, $source_url)) === false) {
			// \[X URI ̃f[^Ƀ^[Qbg URI ւ̃N݂Ȃ߁A\[XƂĎgpłȂB
			return self::RESPONSE_FAULT_SOURCE_LINK;
		}

		// TCg̃^Cg擾iXMLƂďHj
		$source_titles = array();
		preg_match('/<title>([^<]*?)</title>/is', $source_body, $source_titles);
		// ^Cg݂ȂUntitled
		$source_title = empty($source_titles[1]) ? self::UNTITLED_TITLE : $source_titles[1];

		// ^[Qbg̃NG擾iTCgj
		$query = $target_url->getQuery();
		if ( empty($query) ){
			// http://[host]/[pagename]̏ꍇiXbV͍ăGR[hj
			$r_page = str_replace('/', '%2F', $target_url->getPath());
			// $url_suffix܂܂ꍇAK\ł폜
			//$page = empty($url_suffix) ? $r_page : preg_replace('/'.$url_suffix.'$/', '', $r_page);
			$page = rawurldecode($r_page);
			unset($r_page);
		}else{
			// ^[Qbg=܂܂ꍇ̓y[Wł͂Ȃ̂Ŗ
			if (strpbrk($query, '=')) return self::RESPONSE_FAULT_TARGET_INVALID;
			$page = $query;
		}

		// y[WWikiĂяo
		$wiki = Factory::Wiki($page);
		
		if (!$wiki->isValied()){
			// ȃy[W
			return self::RESPONSE_FAULT_TARGET_INVALID;
		}

		if (!$wiki->isReadable()){
			// ǂݍݕsȃy[W
			return self::RESPONSE_FAULT_ACCESS_DENIED;
		}

		// PingBackt@Cǂݍ
		$pb = new PingBackFile($page);
		$lines = $pb->get();
		
		if (count($lines) !== 0){
			foreach ($lines as $line){
				list($time, $url, $title) = explode("\t", $line);
				
				if ($url === $target_url){
					// łɓo^Ă
					return self::RESPONSE_FAULT_ALREADY_REGISTERED;
				}
			}
		}
		// Vf[^[o^
		$lines[] = join("\t", array(UTIME, $source_url, $source_title));
		// ۑ
		$pb->set($lines);
		
		return self::RESPONSE_SUCCESS;
	}
}