// PukiWiki - Yet another WikiWikiWeb clone.
// CKEditor for PukiWiki GUIedit

// Copyright (c) 2010 PukiWiki Advance Developer Team

// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 2 of the License, or
// (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.


// This program is inspired from garand's guiedit works.
// But this is NOT compatible to garand's version.

/* jslint evil: true */

var pukiwiki_guiedit = {
	meta : {
		'@prefix': '<http://purl.org/net/ns/doas#>',
		'@about': '<guiedit.js>', a: ':JavaScript',
		 title: 'GUIEdit wraping script for Pukiwiki Advance',
		 created: '2010-09-03', release: {revision: '1.0.0', created: '2010-09-03'},
		 author: {name: 'Logue', homepage: '<http://logue.be/>'},
		 acknowledgement: {name: "܂[nJ", 'homepage': "<http://teao.te.kyusan-u.ac.jp/bluemoon/index.php?%A5%D7%A5%E9%A5%B0%A5%A4%A5%F3%2FGUI%CA%D4%BD%B8>" },
		 license: '<http://www.gnu.org/licenses/gpl-2.0.html>'
	},
	// CKEditor̐ݒiCKEditor.config̃GCAXj
	// http://docs.cksource.com/CKEditor_3.x/Developers_Guide/Setting_Configurations
	config:{
		// CKEditor̃XL
		skin : 'moono',
		// TCŶ݂ɂ
		resize_dir : 'vertical',
		// GfBb^̃X^CV[g
		contentsCss : [COMMON_URI+'css/bootstrap.min.css', COMMON_URI+'css/fontawasome.min.css', COMMON_URI+'css/pukiwiki.css'],
		// vOC
//		extraPlugins : 'InternalEx, FontFormatEx,AlignEx,ListEx,IndentEx,InsertText,PukiWikiPlugin,TableEx,HRuleEx,SmileyEx,SpecialCharEx,Comment',
		// ^錾
		// docType: '<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">',
		docType: '<!DOCTYPE html>',	// Adv.HTML5
		//	IuWFNg̃TCYύX𖳌
		disableObjectResizing: true,
		//	\[X̃|bvAbv
		// SourcePopup : true,	// `H
		//	V[gJbgL[
		keystrokes : [
			[ CKEDITOR.CTRL + 65 /*A*/, true ],
			[ CKEDITOR.CTRL + 67 /*C*/, true ],
			[ CKEDITOR.CTRL + 70 /*F*/, true ],
			[ CKEDITOR.CTRL + 83 /*S*/, true ],
			[ CKEDITOR.CTRL + 88 /*X*/, true ],
			[ CKEDITOR.CTRL + 86 /*V*/, 'Paste' ],
			[ CKEDITOR.CTRL + 90 /*Z*/, 'Undo' ],
			[ CKEDITOR.CTRL + 89 /*Y*/, 'Redo' ],
			[ CKEDITOR.CTRL + 76 /*L*/, 'Link' ],
			[ CKEDITOR.CTRL + 50 /*B*/, 'Bold' ],
			[ CKEDITOR.CTRL + 73 /*I*/, 'Italic' ],
			[ CKEDITOR.CTRL + 85 /*U*/, 'Underline' ],
			[ CKEDITOR.CTRL + CKEDITOR.ALT + 13 /*ENTER*/, 'FitWindow' ],
			[ CKEDITOR.CTRL + CKEDITOR.ALT + 83 /*S*/, 'Source' ]
		],
		//	c[o[
		toolbar : [
			['Source','-','Cut','Copy','Paste','PasteText','PasteWord','-','SpellCheck'],
			['Undo','Redo','-','Find','Replace','-','SelectAll','RemoveFormat'],
			['Link','Unlink','Anchor'],
			['InsertText','Attachment','PukiWikiPlugin','Note','Comment'],
			['Table','Rule','Smiley','SpecialChar','-','PageBreak'],
			['FitWindow','ShowBlocks','-','About'],
			'/',
			['FontFormat','FontSize'],
			['Bold','Italic','Underline','StrikeThrough','-','Subscript','Superscript'],
			['OrderedList','UnorderedList','DList','-','Outdent','Indent','Blockquote'],
			['JustifyLeft','JustifyCenter','JustifyRight','JustifyFull'],
			['TextColor','BGColor']
		],
		//	ReLXgj[
		menu_groups : ['Generic','Link','Anchor'],
		// tH[}bg
	
		// ̑
		fontSize_sizes : '8px;9px;10px;11px;12px;14px;16px;18px;20px;24px;28px;32px;40px;48px;60px;'
			+ 'xx-small;x-small;small;medium;large;x-large;xx-large',
		coreStyles_bold: {element : 'strong'},
		coreStyles_italic: {element :'em'},
		// N

	},
	init: function(){
		var self = this;
		// tH[̃bN
		$('input','button','select','textarea').attr('disabled','disabled');
		this.editor = $('textarea[name=msg]');	// ϊtH[
		this.editor.ckeditor(
			function(){
				
				// CKEditorsOɎs鏈
				$("textarea[name='msg']").before('<div id="indicator" style="text-align:right;"></div>');
				// vr[ʂDOM
				$('#guiedit').append('<div id="realview" class="form-control"></div>');
				// CWP[^[
				$('#indicator').html('<span class="fa fa-spin fa-spinner"></span>Now Loading...');
				$('#indicator').animate({height:'20px'});
				// ftHg̃eLXgǂݍ
				
				self.load();
			}
			//this.config	// ݒ
		);
		var common_uri = COMMON_URI ? COMMON_URI : '/';
		this.CKEditor = this.editor.ckeditorGet();	// CKEditor̃GCAX
		this.CKEditor.config.contentsCss = [common_uri+'css/bootstrap.min.css', common_uri+'css/font-awesome.min.css', common_uri+'css/pukiwiki.css'];
	},
	// [h
	load : function(){
		var self = this;
		// eLXgGA̓e擾
		// āAXLUIblockg
		$.ajax({
			url:SCRIPT,
			dataType:'json',
			type:'GET',
			data: {
				cmd : 'guiedit',
				edit: 1,
				page: $('input[name=page]').val(),
				id:$('input[name=id]').val()
			},
			success: function(data){
				self.editor.val(data.msg);
				// ɂԂCWP[^[ɕ\
				$('#indicator').html('<span class="fa fa-clock-o"></span>Convert time :'+data.taketime);
	
				// e{^̃Cxg
				$('[name=write]').click(function(){
					self.write();
				});
	
				// vr[{^̃Cxg
				$('[name=preview]').click(function(){
					self.preview();
				});
	
				// ev[g̃|bvAbvj[̃Cxg蓖āilύXɃCxgsj
				$('[name=template_page]').change(function(){
					self.template();
				});
	
				// tH[bN
				$('input','button','select','textarea').attr('disabled');
			},
			error : function(data,status,thrown){
				alert(status);
				console.error(data.responseText);
				$('input[name=cancel]').attr('disabled');
			}
		});
	},
	// ev[gďo
	template: function(){
		var self = this;
		$.ajax({
			url:SCRIPT,
			dataType:'json',
			type:'POST',
			data: {
				cmd : 'guiedit',
				edit: 1,
				page: PAGE,
				template_page:$('select[name=template_page]').val()
			},
			beforeSend: function(){
				$('#indicator').html('<span class="fa fa-spin fa-spinner"></span>Now Loading...');
				$('input','button','select','textarea').attr('disabled','disabled');
			},
			success: function(data){
				self.editor.val(data.msg);
				$('#indicator').html('<span class="fa fa-clock-o"></span>Convert time :'+data.taketime);
			},
			error : function(data,status,thrown){
				$('#indicator').html('<span class="fa fa-warning"></span>Error!');
				console.error(data);
				$('input[name=cancel]').attr('disabled');
			}
		});
	},
	// vr[擾
	preview: function(){
		var self = this;
		$.ajax({
			url:SCRIPT,
			dataType:'json',
			type:'POST',
			global : false,
			data: {
				cmd : 'guiedit',
				edit: 1,
				page: $('input[name=page]').val(),
				msg : this.editor.val()
			},
			beforeSend: function(){
				$('#indicator').html('<span class="fa fa-spin fa-spinner"></span>Now Loading...');
				$('input','button','select','textarea').attr('disabled','disabled');
			},
			success: function(data){
				$("#realview_outer").animate({height:'200px'});
				$('#indicator').html('<span class="fa fa-clock-o"></span>Convert time :'+data.taketime);
				$('input','button','select','textarea').attr('disabled');
				$("#realview").html(data.msg);
			},
			error : function(data,status,thrown){
				$('#indicator').html('<span class="fa fa-warning"></span>Error!');
				console.error(status);
				console.dir(data);
				$('[name=cancel]').removeAttr('disabled');
			}
		});
	},
	// 
	write: function(){
		this.unload(true);
	},
	// y[Wo鎞
	unload: function(bEnable){
		window.onbeforeunload = function () {
			if(bEnable && this.CKEditor.checkDirty()){
				return 'sƕύXej܂B';
			}
			return;
		};
	}
};

$(document).ready(function(){
	pukiwiki_guiedit.init();
});

