<?php
/**
 * ZendSearchiLucenejɂ錟
 *
 * @package   PukiWiki
 * @access    public
 * @author    Logue <logue@hotmail.co.jp>
 * @copyright 2013-2014 PukiWiki Advance Developers Team
 * @create    2013/05/23
 * @license   GPL v2 or (at your option) any later version
 * @version   $Id: Search.php,v 1.0.3 2014/03/10 19:24:00 Logue Exp $
 */
namespace PukiWiki;

use PukiWiki\Auth\Auth;
use PukiWiki\Factory;
use PukiWiki\Utility;
use Igo\Tagger;
use ZendSearch\Lucene\Lucene;
use ZendSearch\Lucene\Document\Html as LuceneDocHtml;
/**
 * NX
 */
class SearchLucene extends Search{
	/**
	 * CfbNX
	 */
	const INDEX_NAME = 'search-index';
	/**
	 * CfbNXt@C𐶐
	 */
	public static function updateIndex(){
		static $igo;
		
		if (empty($igo)){
			$igo = new Tagger('../ipadic', 'reduce_mode'  => true);
		}
		// ̍쐬
		$index = Lucene::create(CACHE_DIR . self::INDEX_NAME);
		foreach (Listing::pages() as $page) {
			
			if (empty($page)) continue;

			$wiki = Factory::Wiki($page);

			// ǂތȂꍇXLbv
			if (!$wiki->isReadable() || $wiki->isHidden()) continue;
			
			// HTMLo
			$html[] = '<html><head>';
			$html[] = '<meta http-equiv="Content-type" content="text/html; charset=UTF-8"/>';
			$html[] = '<title>' . $wiki->title() . '</title>';
			$html[] = '</head>';
			// HTMLeLXgɕϊĕ̂bodyƂB
			$html[] = '<body>' . $igo->wakati(strip_tags($wiki->render)) . '</body>';
			$html[] = '</html>';
			// HTML̉
			$doc = LuceneDocHtml::loadHTML(join("\n", $html), false);
			
			// ֕̓o^
			$index->addDocument($doc);
		}
		
		//$hits = $index->find('hoge');
		//var_dump($hits);
	}
	/**
	 * C
	 * @param string $word [h
	 * @param string $type @iand, orj
	 * @param boolean $non_format
	 * @param string $base x[XƂȂy[W
	 * @return string
	 */
	public static function do_search($word, $type = 'and', $non_format = FALSE, $base = ''){
		// CfbNXt@CJ
		$index = Lucene::open(CACHE_DIR . self::INDEX_NAME);
		
		// NGp[X
		$query = \ZendSearch\Lucene\Search\Query\Boolean();
		$keys = parent::get_search_words(preg_split('/\s+/', $word, -1, PREG_SPLIT_NO_EMPTY));
		// Luceneɓn
		foreach ($keys as $key=>$value)
			$query->addSubquery( new \ZendSearch\Lucene\Index\Term($value), true);
		
		//  Ǝs
		$hits = $index->find($query);
		var_dump($hits);
		
		if ($non_format){
			//
		}
		return $hits;
	}
}