<?php
define(_PARAEDIT_VERSION, 0.6);
/*

* パラグラフ指向化プラグイン - paraedit 0.6

PukiWikiでパラグラフ単位の編集をできるようにするプラグインです。


** インストール方法

次の4ステップで簡単にインストールできます。

*** pukiwiki.php に追加
メイン処理の直前に次の二行を追加。(paraedit 0.6以降)
 include_once('plugin/paraedit.inc.php');
 $post["msg"] = _plugin_paraedit_parse_postmsg($post["msg_before"], $post["msg"], $post["msg_after"]);
paraedit 0.5までの場合は次の二行を追加。
 $post[msg] = $post[msg_before] . $post[msg] . $post[msg_after];
 $post["msg"] = preg_replace("/((\x0D\x0A)|(\x0D)|(\x0A))/","\n",$post["msg"]);

*** skin (skin/pukiwiki.skin.ja.php) の書換え
php echo $body を次の一行に置換。
 php include_once 'plugin/paraedit.inc.php'; echo _plugin_paraedit_mkeditlink($body);

*** paraedit.inc.php のコピー
#ref(paraedit.inc.php)
をダウンロードして plugin ディレクトリ (./plugin) に paraedit.inc.php をコピー。
*** convert_html() の書換え
- 1.3.5 の場合
html.php の編集。function convert_html 内にある、

 array_push($result, "<h$level><a name=\"content_{$content_id_local}_$content_count\"></a>$str $top_link</h$level>");

上の一行を下の二行に置換。

 $paraedit_flag = ($content_id_local == 1) ? ' paraedit_flag=on' : '';
 array_push($result, "<h$level $paraedit_flag><a name=\"content_{$content_id_local}_$content_count\"></a>$str $top_link</h$level>");


- 1.4rc3 の場合
convert_html.php の編集。class Heading extends Block 内にある、

 return $this->msg_top.
 	$this->wrap(parent::toString(),'h'.$this->level," id=\"{$this->id}\"");

上の二行を下の三行に置換。

 $paraedit_flag = (preg_match("/^content_1_/", $this->id)) ? ' paraedit_flag=on' : '';
 return $this->msg_top.
 	$this->wrap(parent::toString(),'h'.$this->level," id=\"{$this->id}\"$paraedit_flag");

*** カスタマイズ (オプション)
[edit] の文字や挿入場所を変更したい場合は、paraedit.inc.php の define で
始まる行を編集して下さい。


以上。


** Copyright
tmk http://linux.s33.xrea.com:8080/SxWiki/

** Licence
GPL2 (GNU General Public License version 2)

** Bugs & ToDo
- pukiwiki.php を書き換えなくても動作するようにしたい

** Version
- 0.1 2003/06/28 1.3.5用
- 0.2 2003/07/01
- 0.3 2003/07/04 1.3.5, 1.4.rc3両用
- 0.4 2003/07/13
- 0.5 2003/08/31
- 0.6 2003/09/06

** Changes
- since 0.1
-- _EDIT_LINK から $_title_edit へ変更
-- _PARAEDIT_LINK_POS でリンクを挿入する場所を選択可能
- since 0.2
-- PukiWiki 1.4系向け改造
-- edit_form() の引数順序
-- &refer=... を追加し、$page を変更
- since 0.3
-- calender_viewer や include プラグイン対策
-- <h2 ... paraedit_flag=on> の場合のみ [edit] を挿入
-- convert_html() の書換えが必要になった
- since 0.4
-- <input type=hidden> から <textarea> に変更
-- check_editable() を追加
-- &parnum から &amp;parnum に変更
- since 0.5
-- <textarea> から <input type=hidden> に変更 (Opera対策)
-- 改行代替文字列による改行 (Mozilla対策)
-- 改行コードの統一
-- 上記変更により pukiwiki.php の書換え方法を変更

*/

// 編集リンクの文字列・スタイルを指定
//   %s に URL が入る
// define(_EDIT_LINK, '<div style="text-align: right; font-size: x-small; padding: 0px; "><a href="%s">[edit]</a></div>');
define(_EDIT_LINK, '<span class="editsection">[<a href="%s">編集</a>]</span>'); // Monobook for PukiWiki用設定

// 編集リンクの挿入箇所を指定
//   <h2>header</h2> の時、$1:<h2>, $2:header, $3:</h2> となるので $link を好きな場所に移動
// (例)
//   define(_PARAEDIT_LINK_POS, '$1$2$link$3'); // </h2>の前
//   define(_PARAEDIT_LINK_POS, '$link$1$2$3'); // <h2>の前
//   define(_PARAEDIT_LINK_POS, '$1$2$3$link'); // </h2>の後ろ
define(_PARAEDIT_LINK_POS, '$1$link<span class=\"headline\">$2</span>$3'); // Monobook for PukiWiki用設定

// 改行の代替文字列
//   <input type=hidden value=XXXXX> で改行(CR,LFなど)の変わりに使用する文字列
define(_PARAEDIT_SEPARATE_STR, '_PaRaeDiT_');


function plugin_paraedit_init()
{
	// init
	// プログラムファイル読み込み
	include("../init.php");
}


function plugin_paraedit_convert()
{
	// HTML にコンバート時に呼び出される
	return "ParaEdit version ". _PARAEDIT_VERSION . "\n";
}


function plugin_paraedit_action()
{
	// GET POST 時に呼び出される
	global $script, $get, $post, $vars;
	global $_title_edit; // $LANG.lng で定義済
	
	// 編集不可能なページを編集しようとしたとき
	if (S_VERSION < 1.4) {
		if (is_freeze($vars["page"]) || !is_editable($vars["page"]) || $vars["page"] == "")
		{
			$wikiname = rawurlencode($vars["page"]);
			header("Location: $script?cmd=edit&page=$wikiname");
			die();
		}
	} else {
		// check_editable($page, BASIC認証表示, NG画面に遷移)
		check_editable($vars["page"], true, true);
	}

	// pukiwiki.php から拝借
	$postdata = @join("",get_source($get["page"]));
	if($postdata == '') {
		$postdata = auto_template($get["page"]); # should be test
	}
	
	#$page = str_replace('$1',make_search($get["page"]), $_title_edit);
	$page = $_title_edit;
	
	// edit_form() で $postdata = $vars[refer] . $postdata; となるため小細工
	$refer = $vars["refer"];
	$vars["refer"] = "";
	
	if (S_VERSION < 1.4) {
		$body = edit_form($postdata, $get["page"]); // v 1.3.5
	} else {
		$body = edit_form($get["page"], $postdata);  // v 1.4
	}
	
	$vars["refer"] = $refer;
	
	// <textarea name="msg" ...> 前後で分割
	$lines = array();
	$textareas = array(); // 0: whole, 1: before msg, 2: textarea tag, 3: msg 4: after msg
	preg_match("/^(.*?)(<textarea .*?>)(.*?)(<\/textarea>.*)$/is", $body, $textareas);
	
	// 改行コードを \n に統一
	$vars["msg"] = preg_replace("/((\x0D\x0A)|(\x0D)|(\x0A))/", "\n", $vars["msg"]);
	
	// $vars[msg] を分割
	$msg_before; $msg_now; $msg_after; // 編集行とその前後
	$part = $vars["parnum"];
	$index_num = 0;
	$is_first_line = 1;
	foreach (split ("\n", $textareas[3]) as $line) {
		if (preg_match("/^\*{1,3}/", $line)) {
			$index_num++;
		}
		if (!$is_first_line) { $line = "\n$line"; } else { $is_first_line = 0; }
		if ($index_num < $part) {
			$msg_before .= $line;
		} else if ($index_num == $part) {
			$msg_now .= $line;
		} else if ($index_num > $part) {
			$msg_after .= $line;
		}
	}
	
	// 微調整 (silly!)
	$msg_before = preg_replace("/^\n/", "", $msg_before);
	if ($msg_before) { $msg_before .= "\n"; }
	
	// 改行コードを書換え
	$msg_before = preg_replace("/\n/", _PARAEDIT_SEPARATE_STR, $msg_before);
	$msg_after  = preg_replace("/\n/", _PARAEDIT_SEPARATE_STR, $msg_after);
	
	// 結合
	$body = $textareas[1]
		. '<input type=hidden name="msg_before" value="' . $msg_before . '">' . "\n"
		. '<input type=hidden name="msg_after"  value="' . $msg_after  . '">' . "\n"
		. $textareas[2]  . $msg_now . $textareas[4];
	#$body = $textareas[1]
	#	. '<textarea name="msg_before"  style="display: none" readonly>' ."\n". $msg_before . '</textarea>' . "\n"
	#	. '<textarea name="msg_after"   style="display: none" readonly>' ."\n". $msg_after  . '</textarea>' . "\n"
	#	. $textareas[2]  . $msg_now . $textareas[4];

	// ヘルプ表示 : リンク書き換え
	$body = preg_replace("/(cmd=edit&amp;help=true)/", "plugin=paraedit&amp;parnum=$vars[parnum]&$1&amp;refer=" . rawurlencode($vars[page]), $body);

	return array("msg" => $page, "body" => $body);
}

function _plugin_paraedit_mkeditlink($body)
{
	// [edit]リンクの作成
	global $script, $get, $post, $vars;
	$lines = split("\n", $body);
	
	$para_num = 1;
	$lines2 = array();
	foreach ($lines as $line) {
		#if (preg_match("/<\/h\d>$/", $line)) {
		if (preg_match("/<h\d .*? paraedit_flag=on/", $line)) {
			#$link = "$script?plugin=paraedit&parnum=$para_num&page=" . rawurlencode($vars[page]); // v 1.3.5
			$line = preg_replace("/ paraedit_flag=on/", "", $line);
			$link = "$script?plugin=paraedit&amp;parnum=$para_num&amp;page=" . rawurlencode($vars[page]) . '&amp;refer=' . rawurlencode($vars[page]); // v 1.4
			$link = sprintf(_EDIT_LINK, $link);
			$replaced = _PARAEDIT_LINK_POS;
			eval(" \$replaced = \"$replaced\"; ");
			$line = preg_replace("/(<h\d.*?>)(.*)(<\/h\d>)/", $replaced, $line);

			$para_num++;
		}
		array_push($lines2, $line);
	}
	
	$body = @join("\n", $lines2);
	return $body;
}


function _plugin_paraedit_parse_postmsg($msg_before, $msg_now, $msg_after)
{
	// pukiwiki.php から呼び出し、
	// $post["msg_*"] を整形・結合して $post["msg"] を返す
	
	if ($msg_before == "" && $msg_after == "") { return $msg_now; }
	
	// 改行代替文字列を \n に変換
	$msg_before = str_replace(_PARAEDIT_SEPARATE_STR, "\n", $msg_before);
	$msg_now    = str_replace(_PARAEDIT_SEPARATE_STR, "\n", $msg_now);
	$msg_after  = str_replace(_PARAEDIT_SEPARATE_STR, "\n", $msg_after);
	
	// 整形
	//$msg_before .= (preg_match("/\n$/", $msg_before)) ? "" : "\n";
	//$msg_now    .= (preg_match("/\n$/", $msg_now)   ) ? "" : "\n";
	
	// 結合
	return $msg_before . $msg_now . $msg_after;
}

?>