/* -*- mode:objc; coding:utf-8; tab-width:8; c-basic-offset:2; indent-tabs-mode:nil -*- */

#import <OgreKit/OgreKit.h>
#import "PufuiController.h"

static PufuiController *sharedController = nil;

@implementation PufuiController

+ (id)sharedController
{
  return sharedController;
}

- (id)init
{
  self = [super initWithWindowNibName:@"Pufui" owner:self];
  sharedController = self;

  if (self) {
    firstTime = YES;
    forward = YES;
    direct = YES;
    wrapping = NO;
    lastSearchStr = nil;

    cmigemo = migemo_open(MIGEMO_DICT);
  }

  return self;
}

- (void)dealloc
{
  if (cmigemo)
    migemo_close(cmigemo);

  [super dealloc];
}

/*
 * search forward
 *
 * This method will be launched by InputManager.
 */
- (IBAction)searchForward:(id)sender
{
  direct = YES;

  //[self showWindow:self];
  [self showSearchWindow:sender];
  [self search:YES];
}

/*
 * search backward
 * 
 * This method will be launched by InputManager.
 */
- (IBAction)searchBackward:(id)sender
{
  direct = YES;

  //[self showWindow:self];
  [self showSearchWindow:sender];
  [self search:NO];
}

/*
 * abort current operation
 *
 * This method will be launched by InputManager.
 */
- (IBAction)abort:(id)sender
{
  //NSLog(@"PufuiController::abort:");

  [[self window] orderOut: self];
  NSResponder *resp = [[NSApp mainWindow] firstResponder];
  if ([resp isKindOfClass: [NSTextView class]]) {
    NSTextView *textView = (NSTextView *) resp;
    [textView swapWithMark: sender];
    [textView scrollRangeToVisible: [textView selectedRange]];
  }
}

/*
 * search field action handler
 */
- (IBAction)searchField:(id)sender
{
  //NSLog(@"PufuiController::searchField:");

  direct = NO;
  [self search:forward];

  if (!lastSearchStr)
    lastSearchStr = [[NSString alloc] initWithString:[searchField stringValue]];
  else if ([[searchField stringValue] isEqualToString:lastSearchStr])
    [[self window] orderOut:self];
  else {
    [lastSearchStr release];
    lastSearchStr = [[NSString alloc] initWithString:[searchField stringValue]];
  }
}

- (void)showSearchWindow:(id)sender
{
  NSWindow *searchWindow = [self window];
  if (![searchWindow isVisible]) {
    NSView *view = [sender enclosingScrollView];
    if (view == nil) view = sender;
    NSRect textFieldRect = [view convertRect: [view bounds] toView: nil];
    NSWindow *textFieldWindow = [view window];
    textFieldRect.origin = [textFieldWindow convertBaseToScreen: textFieldRect.origin];
    [searchWindow setFrameTopLeftPoint: textFieldRect.origin];
    NSRect visibleFrame = [[textFieldWindow screen] visibleFrame];
    if (!NSContainsRect(visibleFrame, [searchWindow frame])) {
      NSPoint textFieldTopLeft = { textFieldRect.origin.x, textFieldRect.origin.y + textFieldRect.size.height};
      [searchWindow setFrameOrigin: textFieldTopLeft];
    }
    firstTime = YES;
  }

  direct = YES;
  [self showWindow:self];
}

- (void)search:(BOOL)aForward
{
  id resp = [[NSApp mainWindow] firstResponder];

  if ([resp isKindOfClass:[NSTextView class]]) {
    NSRange range;
    NSString *str = [resp string];
    unsigned textLen = [[resp textStorage] length];
    NSRange selectedRange = [resp selectedRange];
    NSString *migStr = nil;
    NSString *searchStr = [searchField stringValue];

    /*
    NSLog(@"PufuiController::search: forward=%s direct=%s wrapping=%s strlen=%d searchStr='%@'",
          forward ? "YES" : "NO",
          direct ? "YES" : "NO",
          wrapping ? "YES" : "NO",
          [str length], searchStr);
    */

    if (firstTime)
      [resp setMark:self];

    forward = aForward;

    if (wrapping) {
      // search from top of the text
      currentRange = NSMakeRange(0, textLen);
    }
    else {
      if (direct) {
        if (forward) {
          currentRange.location = selectedRange.location + selectedRange.length;
        }
        else {
          currentRange.length = selectedRange.location;
        }
      }
      // if the action handler was called indirectly,
      // old position will be used again

      if (forward) {
        // between current position and end of text
        currentRange.length = textLen - currentRange.location;
      }
      else {
        // between top of text and current position
        currentRange.location = 0;
      }
    }

    /*
    NSLog(@"PufuiController::search: currentRange.location=%d currentRange.length=%d str='%@'",
          currentRange.location, currentRange.length,
          [str substringWithRange:currentRange]);
    */

    {
      unsigned char *buf;
      unsigned char *migRes;

      buf = (unsigned char *) malloc(sizeof(unsigned char) *
                                     [searchStr length] + 1);

      [[searchStr dataUsingEncoding:NSJapaneseEUCStringEncoding]
        getBytes:buf
        length:[searchStr length]];
      buf[[searchStr length]] = '\0';

      migRes = migemo_query(cmigemo, buf);
      free(buf);

      if (migRes) {
        NSData *data = [NSData dataWithBytes:migRes length:strlen((char *) migRes)];
        migStr = [[NSString alloc] initWithData:data
                                   encoding:NSJapaneseEUCStringEncoding];
        migemo_release(cmigemo, migRes);
      }
      else
        migStr = nil;

      //NSLog(@"[%@] %@", searchStr, migStr);
    }

    if ([searchStr isEqualToString:@""])
      range = selectedRange;
    else {
      if (!migStr || [migStr length] >= 1000) {
        range.location = NSNotFound;
        range.length = 0;
      }
      else
        range = [[str substringWithRange:currentRange] rangeOfRegularExpressionString:migStr];

      //NSLog(@"PufuiController::search: range.location=%d range.length=%d",
      //      range.location, range.length);

      if (range.location == NSNotFound) {
        /* pattern not found */
        if (!firstTime) NSBeep();
        wrapping = YES;
        return;
      }
      else {
        /* pattern found */
        range.location += currentRange.location;
        if (forward)
          currentRange = NSMakeRange(range.location, (textLen - range.location));
        wrapping = NO;
      }

      firstTime = NO;
      [resp setSelectedRange:range];
      [resp scrollRangeToVisible:range];
    }
    [migStr release];
  }
  else
    NSBeep();
}

/*
 * NSControl's delegate method
 */
- (void)controlTextDidChange:(NSNotification *)aNotification
{
  //NSLog(@"PufuiController::controlTextDidChange:");

  direct = NO;
  [self search:forward];
}

@end
