/* -*- mode:objc; coding:utf-8; tab-width:8; c-basic-offset:2; indent-tabs-mode:nil -*- */

#import <Cocoa/Cocoa.h>
#import <Migemo/migemo.h>

#define MIGEMO_DICT  "/Library/InputManagers/Pufui/Pufui.bundle/Contents/Frameworks/Migemo.framework/Versions/Current/share/migemo/euc-jp/migemo-dict"

@interface PufuiController : NSWindowController
{
  IBOutlet id searchField;

  /* current text range */
  NSRange currentRange;

  /* requested for the first time */
  BOOL firstTime;

  /* search forward(YES) or backward(NO) */
  BOOL forward;

  /* search action handler has been called by InputManager directly */
  BOOL direct;

  /* will search again from top of the text */
  BOOL wrapping;

  /* last search string */
  NSString *lastSearchStr;

  /* C/Migemo object */
  migemo *cmigemo;
}

+ (id)sharedController;

- (IBAction)searchForward:(id)sender;
- (IBAction)searchBackward:(id)sender;
- (IBAction)abort:(id)sender;
- (IBAction)searchField:(id)sender;

- (void)showSearchWindow:(id)sender;
- (void)search:(BOOL)aForward;

@end
