/*
 *  psychlops_io_file.h
 *  Psychlops Standard Library (Universal)
 *
 *  Last Modified 2005/10/10 by Kenchi HOSOKAWA
 *  (C) 2005 Kenchi HOSOKAWA, Kazushi MARUYA, Takao SATO
 */

#ifndef HEADER_PSYCHLOPS_IO_FILE
#define HEADER_PSYCHLOPS_IO_FILE


#include <string>


namespace Psychlops {


	class File {
		private:
		static bool appname_initialized;
		public:
		enum { PATH_APP=0, PATH_RSC, PATH_HOME, PATH_SETTING, PATH_DOCUMENTS, PATH_DOCUMENTS_ROOT };
		struct PATH_ID_STRING {
			std::string path;
			const std::string id_string;
			const unsigned int id_string_length;
			PATH_ID_STRING(const char * id_str);
		};
		static PATH_ID_STRING STANDARD_PATH[6];
		static const char PATH_DEVIDER;

		public:
		static void initialize();
		static void initialize_appname();
		static std::string getCurrentDirectory();
		static void setCurrentDirectory(const std::string &path, bool force_mkdir);
		static void setCurrentDirectoryDefault();
		static std::string decodePath(const char * path);
		static std::string decodePath(const std::string &path);
		static std::string replacePathDevider(const std::string &path);
	};


}	/*	<- namespace Psycholops 	*/


#endif
