/*
 *  psychlops_widgets_prototype.h
 *  Psychlops Standard Library (Universal)
 *
 *  Last Modified 2009/02/15 by Kenchi HOSOKAWA
 *  (C) 2009 Kenchi HOSOKAWA, Kazushi MARUYA, Takao SATO
 */

#ifndef HEADER_PSYCHLOPS_WIDGET
#define HEADER_PSYCHLOPS_WIDGET

#include <string>
#include "../../../core/graphic/psychlops_g_module.h"
#include "../../../psychlops_core.h"
#include "../psychophysics/psychlops_exp_psychophysics.h"


namespace Psychlops {

	class Widget : public Figure {
		class Event {
		};
	};


namespace Widgets {

	Point drawableMouse(Drawable &d);

	class WidgetDatum : public Widget {
	public:
		Point datum;
		WidgetDatum();
		~WidgetDatum();
		virtual const Point getDatum() const;
		virtual WidgetDatum& setDatum(const Point&);
		virtual WidgetDatum& centering(const Point&);
		using Figure::centering;
	};

	class Button : public WidgetDatum {
	protected:
		Rectangle rect;
		Letters let;
		void (*onClick)();
		bool pressed, pushed_;
	public:
		Button();
		Button(std::wstring s);
		void setBase();
		Button& set(std::wstring s);
		virtual Button& draw(Drawable &target = *Drawable::prime);
		bool pushed();
	};

	class Slider : public WidgetDatum {
	protected:
		Rectangle ext, internal;
		Letters let;
		double local;
		ExperimentalMethods::Variable *var;
		bool pressed, dragged;
		bool changed_;
	public:
		Slider();
		~Slider();
		Slider(double wid, double hei);
		template<typename T, typename S> Slider(T &item, Interval rng, S d_step = 0.125, S e_step = 10)
		{
			setBase();
			set(160,12);
			ExperimentalMethods::VariableInstance<T>* v = new ExperimentalMethods::VariableInstance<T>(&item);
			v->set("", rng, d_step, e_step);
			var = v;
		}
		void setBase();
		Slider& label(std::wstring s);
		Slider& set(double wid, double hei);
		Slider& draw(Drawable &target = *Drawable::prime);
		template<typename T, typename S> Slider& link(T &item, Interval rng, S d_step = 0.125, S e_step = 10)
		{
			ExperimentalMethods::VariableInstance<T>* v = new ExperimentalMethods::VariableInstance<T>(&item);
			v->set("", rng, d_step, e_step);
			var = v;
			return *this;
		}
		bool changed();
		operator double();
		double operator =(double v);
	};

	class Dial : public WidgetDatum {
	protected:
		Rectangle ext, internal;
		Letters let;
		double current_theta, former_theta, factor, local;
		double *var;
		bool pressed, dragged;
		bool changed_;
	public:
		Dial();
		Dial(double r);
		void setBase();
		Dial& label(std::wstring s);
		Dial& set(double r);
		Dial& draw(Drawable &target = *Drawable::prime);
		Dial& link(double &item, double fac = 1)
		{
			var = &item;
			factor = fac;
			let.align = Letters::TEXT_ALIGN_CENTER;
			return *this;
		}
		bool changed();
		operator double();
		double operator =(double v);
	};

}	/*	<- namespace Widgets 	*/
}	/*	<- namespace Psycholops 	*/


#endif
