#pragma once
#include "../../../psychlops_core.h"


namespace Psychlops{
namespace FFTW {

enum FFTWComplex {
	REAL, IMAGINARY
};

// FFT execution - private
/*
void fftExecute(const Matrix &srcReal, const Matrix &srcImaginary,
				Matrix &dstReal, Matrix &dstImaginary,
				fftw_complex *input, fftw_complex *output, const fftw_plan &plan);
*/
void fft2(const Matrix &srcReal, const Matrix &srcImaginary, Matrix &dstReal, Matrix &dstImaginary);
void fft2(const Matrix &src, Matrix &dstReal, Matrix &dstImaginary);
void ifft2(const Matrix &srcReal, const Matrix &srcImaginary, Matrix &dstReal, Matrix &dstImaginary);
void ifft2(const Matrix &srcReal, const Matrix &srcImaginary, Matrix &dst);

// FFT execution - interface
Matrix filterImage(const Matrix &image, const Matrix &filter);
Matrix normalize(const Matrix &matrix);
Matrix fftShift(const Matrix &matrix);
Matrix makeLowPassFilter(int height, int width, double frequency, double octave_sigma);
Matrix makeHighPassFilter(int height, int width, double frequency, double octave_sigma);

// Math etc.
double sigmoid(double x, double d, double a);
double log2NormalDistibution(double log_x, double octave_mu, double octave_sigma);
double cumulativeLog2NormalDistibution(double log_x, double octave_mu, double octave_sigma);
Matrix makeNoise(int height, int width);

}
}
