/*
 *  psychlops_app_info.h
 *  Psychlops Standard Library (Universal)
 *
 *  Last Modified 2005/12/17 by Kenchi HOSOKAWA
 *  (C) 2005 Kenchi HOSOKAWA, Kazushi MARUYA, Takao SATO
 */

#ifndef HEADER_PSYCHLOPS_APPLICATION_INTERFACES_INFORMATION
#define HEADER_PSYCHLOPS_APPLICATION_INTERFACES_INFORMATION


#include <string>
//#include "../../Specific/ApplicationInterfaces/psychlops_app_state.h"


namespace Psychlops {

	class APIApplicationProperties;
	class AppState {
		private:
		static APIApplicationProperties *api_;

		public:
		static const int ImageByteAlignment = 4;
		enum ThreadPriority { HIGH=0, NORMAL, LOW, IDLE, SLEEP };
		static void setThreadPriority( ThreadPriority priority );
		static ThreadPriority getThreadPriority();
		static void initialize();

		static void alert(std::string message);
	};

	class AppInfo {
		private:

		public:
		static int argc;
		static char **argv;
		static std::string appname;
		static std::string expname;
	};


}	/*	<- namespace Psychlops 	*/


#endif
