;;*****************************************************************************
;;*****************************************************************************
;;  FILENAME: PWM8_Timer.inc
;;   Version: 2.5, Updated on 2010/4/6 at 11:27:32
;;  Generated by PSoC Designer 
;;
;;  DESCRIPTION: Assembler declarations for the PWM8 user module interface
;;-----------------------------------------------------------------------------
;;  Copyright (c) Cypress Semiconductor 2010. All Rights Reserved.
;;*****************************************************************************
;;*****************************************************************************

include "m8c.inc"


;--------------------------------------------------
; Constants for PWM8_Timer API's.
;--------------------------------------------------

PWM8_Timer_CONTROL_REG_START_BIT:          equ 0x01    ; Control register start bit
PWM8_Timer_INT_REG:                        equ 0x0e1
PWM8_Timer_INT_MASK:                       equ 0x08


;--------------------------------------------------
; Constants for PWM8_Timer user defined values
;--------------------------------------------------

PWM8_Timer_PERIOD:                         equ 0xd7
PWM8_Timer_PULSE_WIDTH:                    equ 0x00


;--------------------------------------------------
; Register Address Constants for PWM8_Timer
;--------------------------------------------------

PWM8_Timer_COUNTER_REG:                equ 0x2c   ; DR0 Count register
PWM8_Timer_PERIOD_REG:                 equ 0x2d   ; DR1 Period register
PWM8_Timer_COMPARE_REG:                equ 0x2e   ; DR2 Compare register
PWM8_Timer_CONTROL_REG:                equ 0x2f   ; Control register
PWM8_Timer_FUNC_REG:                   equ 0x2c   ; Function register
PWM8_Timer_INPUT_REG:                  equ 0x2d   ; Input register
PWM8_Timer_OUTPUT_REG:                 equ 0x2e   ; Output register


;--------------------------------------------------
; PWM8_Timer Macro 'Functions'
;--------------------------------------------------

   macro PWM8_Timer_Start_M
   or    reg[PWM8_Timer_CONTROL_REG],  PWM8_Timer_CONTROL_REG_START_BIT
   endm

   macro PWM8_Timer_Stop_M
   and   reg[PWM8_Timer_CONTROL_REG], ~PWM8_Timer_CONTROL_REG_START_BIT
   endm

   macro PWM8_Timer_EnableInt_M
   M8C_EnableIntMask PWM8_Timer_INT_REG, PWM8_Timer_INT_MASK
   endm

   macro PWM8_Timer_DisableInt_M
   M8C_DisableIntMask PWM8_Timer_INT_REG, PWM8_Timer_INT_MASK
   endm


; end of file PWM8_Timer.inc
