;;*****************************************************************************
;;*****************************************************************************
;;  FILENAME: PWM8_D.inc
;;   Version: 2.5, Updated on 2010/4/6 at 11:27:32
;;  Generated by PSoC Designer 
;;
;;  DESCRIPTION: Assembler declarations for the PWM8 user module interface
;;-----------------------------------------------------------------------------
;;  Copyright (c) Cypress Semiconductor 2010. All Rights Reserved.
;;*****************************************************************************
;;*****************************************************************************

include "m8c.inc"


;--------------------------------------------------
; Constants for PWM8_D API's.
;--------------------------------------------------

PWM8_D_CONTROL_REG_START_BIT:              equ 0x01    ; Control register start bit
PWM8_D_INT_REG:                            equ 0x0df
PWM8_D_INT_MASK:                           equ 0x04


;--------------------------------------------------
; Constants for PWM8_D user defined values
;--------------------------------------------------

PWM8_D_PERIOD:                             equ 0x00
PWM8_D_PULSE_WIDTH:                        equ 0x00


;--------------------------------------------------
; Register Address Constants for PWM8_D
;--------------------------------------------------

PWM8_D_COUNTER_REG:                    equ 0x48   ; DR0 Count register
PWM8_D_PERIOD_REG:                     equ 0x49   ; DR1 Period register
PWM8_D_COMPARE_REG:                    equ 0x4a   ; DR2 Compare register
PWM8_D_CONTROL_REG:                    equ 0x4b   ; Control register
PWM8_D_FUNC_REG:                       equ 0x48   ; Function register
PWM8_D_INPUT_REG:                      equ 0x49   ; Input register
PWM8_D_OUTPUT_REG:                     equ 0x4a   ; Output register


;--------------------------------------------------
; PWM8_D Macro 'Functions'
;--------------------------------------------------

   macro PWM8_D_Start_M
   or    reg[PWM8_D_CONTROL_REG],  PWM8_D_CONTROL_REG_START_BIT
   endm

   macro PWM8_D_Stop_M
   and   reg[PWM8_D_CONTROL_REG], ~PWM8_D_CONTROL_REG_START_BIT
   endm

   macro PWM8_D_EnableInt_M
   M8C_EnableIntMask PWM8_D_INT_REG, PWM8_D_INT_MASK
   endm

   macro PWM8_D_DisableInt_M
   M8C_DisableIntMask PWM8_D_INT_REG, PWM8_D_INT_MASK
   endm


; end of file PWM8_D.inc
