//*****************************************************************************
//*****************************************************************************
//  FILENAME: PWM8_D.h
//   Version: 2.5, Updated on 2010/4/6 at 11:27:32
//  Generated by PSoC Designer 
//
//  DESCRIPTION: PWM8 User Module C Language interface file
//-----------------------------------------------------------------------------
//  Copyright (c) Cypress Semiconductor 2010. All Rights Reserved.
//*****************************************************************************
//*****************************************************************************
#ifndef PWM8_D_INCLUDE
#define PWM8_D_INCLUDE

#include <m8c.h>

#pragma fastcall16 PWM8_D_EnableInt
#pragma fastcall16 PWM8_D_DisableInt
#pragma fastcall16 PWM8_D_Start
#pragma fastcall16 PWM8_D_Stop
#pragma fastcall16 PWM8_D_bReadCounter              // Read  DR0
#pragma fastcall16 PWM8_D_WritePeriod               // Write DR1
#pragma fastcall16 PWM8_D_bReadPulseWidth           // Read  DR2
#pragma fastcall16 PWM8_D_WritePulseWidth           // Write DR2

// The following symbols are deprecated.
// They may be omitted in future releases
//
#pragma fastcall16 bPWM8_D_ReadCounter              // Read  DR0 (Deprecated)
#pragma fastcall16 bPWM8_D_ReadPulseWidth           // Read  DR2 (Deprecated)


//-------------------------------------------------
// Prototypes of the PWM8_D API.
//-------------------------------------------------

extern void PWM8_D_EnableInt(void);                        // Proxy Class 1
extern void PWM8_D_DisableInt(void);                       // Proxy Class 1
extern void PWM8_D_Start(void);                            // Proxy Class 1
extern void PWM8_D_Stop(void);                             // Proxy Class 1
extern BYTE PWM8_D_bReadCounter(void);                     // Proxy Class 2
extern void PWM8_D_WritePeriod(BYTE bPeriod);              // Proxy Class 1
extern BYTE PWM8_D_bReadPulseWidth(void);                  // Proxy Class 1
extern void PWM8_D_WritePulseWidth(BYTE bPulseWidth);      // Proxy Class 1

// The following functions are deprecated.
// They may be omitted in future releases
//
extern BYTE bPWM8_D_ReadCounter(void);            // Deprecated
extern BYTE bPWM8_D_ReadPulseWidth(void);         // Deprecated


//--------------------------------------------------
// Constants for PWM8_D API's.
//--------------------------------------------------

#define PWM8_D_CONTROL_REG_START_BIT           ( 0x01 )
#define PWM8_D_INT_REG_ADDR                    ( 0x0df )
#define PWM8_D_INT_MASK                        ( 0x04 )


//--------------------------------------------------
// Constants for PWM8_D user defined values
//--------------------------------------------------

#define PWM8_D_PERIOD                          ( 0x00 )
#define PWM8_D_PULSE_WIDTH                     ( 0x00 )


//-------------------------------------------------
// Register Addresses for PWM8_D
//-------------------------------------------------

#pragma ioport  PWM8_D_COUNTER_REG: 0x048                  //DR0 Count register
BYTE            PWM8_D_COUNTER_REG;
#pragma ioport  PWM8_D_PERIOD_REG:  0x049                  //DR1 Period register
BYTE            PWM8_D_PERIOD_REG;
#pragma ioport  PWM8_D_COMPARE_REG: 0x04a                  //DR2 Compare register
BYTE            PWM8_D_COMPARE_REG;
#pragma ioport  PWM8_D_CONTROL_REG: 0x04b                  //Control register
BYTE            PWM8_D_CONTROL_REG;
#pragma ioport  PWM8_D_FUNC_REG:    0x148                  //Function register
BYTE            PWM8_D_FUNC_REG;
#pragma ioport  PWM8_D_INPUT_REG:   0x149                  //Input register
BYTE            PWM8_D_INPUT_REG;
#pragma ioport  PWM8_D_OUTPUT_REG:  0x14a                  //Output register
BYTE            PWM8_D_OUTPUT_REG;
#pragma ioport  PWM8_D_INT_REG:       0x0df                //Interrupt Mask Register
BYTE            PWM8_D_INT_REG;


//-------------------------------------------------
// PWM8_D Macro 'Functions'
//-------------------------------------------------

#define PWM8_D_Start_M \
   PWM8_D_CONTROL_REG |=  PWM8_D_CONTROL_REG_START_BIT

#define PWM8_D_Stop_M  \
   PWM8_D_CONTROL_REG &= ~PWM8_D_CONTROL_REG_START_BIT

#define PWM8_D_EnableInt_M   \
   M8C_EnableIntMask(PWM8_D_INT_REG, PWM8_D_INT_MASK)

#define PWM8_D_DisableInt_M  \
   M8C_DisableIntMask(PWM8_D_INT_REG, PWM8_D_INT_MASK)

#endif
// end of file PWM8_D.h
