//*****************************************************************************
//*****************************************************************************
//  FILENAME: PWM8_C.h
//   Version: 2.5, Updated on 2010/4/6 at 11:27:32
//  Generated by PSoC Designer 
//
//  DESCRIPTION: PWM8 User Module C Language interface file
//-----------------------------------------------------------------------------
//  Copyright (c) Cypress Semiconductor 2010. All Rights Reserved.
//*****************************************************************************
//*****************************************************************************
#ifndef PWM8_C_INCLUDE
#define PWM8_C_INCLUDE

#include <m8c.h>

#pragma fastcall16 PWM8_C_EnableInt
#pragma fastcall16 PWM8_C_DisableInt
#pragma fastcall16 PWM8_C_Start
#pragma fastcall16 PWM8_C_Stop
#pragma fastcall16 PWM8_C_bReadCounter              // Read  DR0
#pragma fastcall16 PWM8_C_WritePeriod               // Write DR1
#pragma fastcall16 PWM8_C_bReadPulseWidth           // Read  DR2
#pragma fastcall16 PWM8_C_WritePulseWidth           // Write DR2

// The following symbols are deprecated.
// They may be omitted in future releases
//
#pragma fastcall16 bPWM8_C_ReadCounter              // Read  DR0 (Deprecated)
#pragma fastcall16 bPWM8_C_ReadPulseWidth           // Read  DR2 (Deprecated)


//-------------------------------------------------
// Prototypes of the PWM8_C API.
//-------------------------------------------------

extern void PWM8_C_EnableInt(void);                        // Proxy Class 1
extern void PWM8_C_DisableInt(void);                       // Proxy Class 1
extern void PWM8_C_Start(void);                            // Proxy Class 1
extern void PWM8_C_Stop(void);                             // Proxy Class 1
extern BYTE PWM8_C_bReadCounter(void);                     // Proxy Class 2
extern void PWM8_C_WritePeriod(BYTE bPeriod);              // Proxy Class 1
extern BYTE PWM8_C_bReadPulseWidth(void);                  // Proxy Class 1
extern void PWM8_C_WritePulseWidth(BYTE bPulseWidth);      // Proxy Class 1

// The following functions are deprecated.
// They may be omitted in future releases
//
extern BYTE bPWM8_C_ReadCounter(void);            // Deprecated
extern BYTE bPWM8_C_ReadPulseWidth(void);         // Deprecated


//--------------------------------------------------
// Constants for PWM8_C API's.
//--------------------------------------------------

#define PWM8_C_CONTROL_REG_START_BIT           ( 0x01 )
#define PWM8_C_INT_REG_ADDR                    ( 0x0df )
#define PWM8_C_INT_MASK                        ( 0x02 )


//--------------------------------------------------
// Constants for PWM8_C user defined values
//--------------------------------------------------

#define PWM8_C_PERIOD                          ( 0x00 )
#define PWM8_C_PULSE_WIDTH                     ( 0x00 )


//-------------------------------------------------
// Register Addresses for PWM8_C
//-------------------------------------------------

#pragma ioport  PWM8_C_COUNTER_REG: 0x044                  //DR0 Count register
BYTE            PWM8_C_COUNTER_REG;
#pragma ioport  PWM8_C_PERIOD_REG:  0x045                  //DR1 Period register
BYTE            PWM8_C_PERIOD_REG;
#pragma ioport  PWM8_C_COMPARE_REG: 0x046                  //DR2 Compare register
BYTE            PWM8_C_COMPARE_REG;
#pragma ioport  PWM8_C_CONTROL_REG: 0x047                  //Control register
BYTE            PWM8_C_CONTROL_REG;
#pragma ioport  PWM8_C_FUNC_REG:    0x144                  //Function register
BYTE            PWM8_C_FUNC_REG;
#pragma ioport  PWM8_C_INPUT_REG:   0x145                  //Input register
BYTE            PWM8_C_INPUT_REG;
#pragma ioport  PWM8_C_OUTPUT_REG:  0x146                  //Output register
BYTE            PWM8_C_OUTPUT_REG;
#pragma ioport  PWM8_C_INT_REG:       0x0df                //Interrupt Mask Register
BYTE            PWM8_C_INT_REG;


//-------------------------------------------------
// PWM8_C Macro 'Functions'
//-------------------------------------------------

#define PWM8_C_Start_M \
   PWM8_C_CONTROL_REG |=  PWM8_C_CONTROL_REG_START_BIT

#define PWM8_C_Stop_M  \
   PWM8_C_CONTROL_REG &= ~PWM8_C_CONTROL_REG_START_BIT

#define PWM8_C_EnableInt_M   \
   M8C_EnableIntMask(PWM8_C_INT_REG, PWM8_C_INT_MASK)

#define PWM8_C_DisableInt_M  \
   M8C_DisableIntMask(PWM8_C_INT_REG, PWM8_C_INT_MASK)

#endif
// end of file PWM8_C.h
