;;*****************************************************************************
;;*****************************************************************************
;;  FILENAME: PWM8_B.inc
;;   Version: 2.5, Updated on 2010/4/6 at 11:27:32
;;  Generated by PSoC Designer 
;;
;;  DESCRIPTION: Assembler declarations for the PWM8 user module interface
;;-----------------------------------------------------------------------------
;;  Copyright (c) Cypress Semiconductor 2010. All Rights Reserved.
;;*****************************************************************************
;;*****************************************************************************

include "m8c.inc"


;--------------------------------------------------
; Constants for PWM8_B API's.
;--------------------------------------------------

PWM8_B_CONTROL_REG_START_BIT:              equ 0x01    ; Control register start bit
PWM8_B_INT_REG:                            equ 0x0e1
PWM8_B_INT_MASK:                           equ 0x04


;--------------------------------------------------
; Constants for PWM8_B user defined values
;--------------------------------------------------

PWM8_B_PERIOD:                             equ 0x00
PWM8_B_PULSE_WIDTH:                        equ 0x00


;--------------------------------------------------
; Register Address Constants for PWM8_B
;--------------------------------------------------

PWM8_B_COUNTER_REG:                    equ 0x28   ; DR0 Count register
PWM8_B_PERIOD_REG:                     equ 0x29   ; DR1 Period register
PWM8_B_COMPARE_REG:                    equ 0x2a   ; DR2 Compare register
PWM8_B_CONTROL_REG:                    equ 0x2b   ; Control register
PWM8_B_FUNC_REG:                       equ 0x28   ; Function register
PWM8_B_INPUT_REG:                      equ 0x29   ; Input register
PWM8_B_OUTPUT_REG:                     equ 0x2a   ; Output register


;--------------------------------------------------
; PWM8_B Macro 'Functions'
;--------------------------------------------------

   macro PWM8_B_Start_M
   or    reg[PWM8_B_CONTROL_REG],  PWM8_B_CONTROL_REG_START_BIT
   endm

   macro PWM8_B_Stop_M
   and   reg[PWM8_B_CONTROL_REG], ~PWM8_B_CONTROL_REG_START_BIT
   endm

   macro PWM8_B_EnableInt_M
   M8C_EnableIntMask PWM8_B_INT_REG, PWM8_B_INT_MASK
   endm

   macro PWM8_B_DisableInt_M
   M8C_DisableIntMask PWM8_B_INT_REG, PWM8_B_INT_MASK
   endm


; end of file PWM8_B.inc
