; Generated by PSoC Designer 
;
INCLUDE "PSoCDynamic.inc"
;==========================================================================
;  PSoCConfig.asm
;  @PSOC_VERSION
;
;  Version: 0.85
;  Revised: June 22, 2004
;  Copyright (c) Cypress Semiconductor 2010. All Rights Reserved.
;
;  This file is generated by the Device Editor on Application Generation.
;  It contains code which loads the configuration data table generated in
;  the file PSoCConfigTBL.asm
;
;  DO NOT EDIT THIS FILE MANUALLY, AS IT IS OVERWRITTEN!!!
;  Edits to this file will not be preserved.
;==========================================================================
;
include "m8c.inc"
include "memory.inc"
include "GlobalParams.inc"

export LoadConfigInit
export _LoadConfigInit
export LoadConfig_hspwmdp
export _LoadConfig_hspwmdp
export UnloadConfig_hspwmdp
export _UnloadConfig_hspwmdp
export ReloadConfig_hspwmdp
export _ReloadConfig_hspwmdp
export LoadConfig_PRSPWM
export _LoadConfig_PRSPWM
export UnloadConfig_PRSPWM
export _UnloadConfig_PRSPWM
export UnloadConfig_Total
export _UnloadConfig_Total
export ACTIVE_CONFIG_STATUS

export NO_SHADOW
export _NO_SHADOW

FLAG_CFG_MASK:      equ 10h         ;M8C flag register REG address bit mask
END_CONFIG_TABLE:   equ ffh         ;end of config table indicator

AREA psoc_config(rom, rel)

;---------------------------------------------------------------------------
; LoadConfigInit - Establish the start-up configuration (except for a few
;                  parameters handled by boot code, like CPU speed). This
;                  function can be called from user code, but typically it
;                  is only called from boot.
;
;       INPUTS: None.
;      RETURNS: Nothing.
; SIDE EFFECTS: Registers are volatile: the A and X registers can be modified!
;               In the large memory model currently only the page
;               pointer registers listed below are modified.  This does
;               not guarantee that in future implementations of this
;               function other page pointer registers will not be
;               modified.
;          
;               Page Pointer Registers Modified: 
;               CUR_PP
;
_LoadConfigInit:
 LoadConfigInit:
    RAM_PROLOGUE RAM_USE_CLASS_4
    RAM_SETPAGE_CUR >ACTIVE_CONFIG_STATUS
	mov		[ACTIVE_CONFIG_STATUS], 0

	lcall	LoadConfig_hspwmdp
	lcall	LoadConfigTBL_hspwmdp_Ordered


    RAM_EPILOGUE RAM_USE_CLASS_4
    ret

;---------------------------------------------------------------------------
; Load Configuration hspwmdp
;
;    Load configuration registers for hspwmdp.
;    IO Bank 0 registers a loaded first,then those in IO Bank 1.
;
;       INPUTS: None.
;      RETURNS: Nothing.
; SIDE EFFECTS: Registers are volatile: the CPU A and X registers may be
;               modified as may the Page Pointer registers!
;               In the large memory model currently only the page
;               pointer registers listed below are modified.  This does
;               not guarantee that in future implementations of this
;               function other page pointer registers will not be
;               modified.
;          
;               Page Pointer Registers Modified: 
;               CUR_PP
;
_LoadConfig_hspwmdp:
 LoadConfig_hspwmdp:
    RAM_PROLOGUE RAM_USE_CLASS_4
	M8C_SetBank1

	push	x
    M8C_SetBank0                    ; Force bank 0
    mov     a, 0                    ; Specify bank 0
    asr     a                       ; Store in carry flag
                                    ; Load bank 0 table:
    mov     A, >LoadConfigTBL_hspwmdp_Bank0
    mov     X, <LoadConfigTBL_hspwmdp_Bank0
    lcall   LoadConfig              ; Load the bank 0 values

    mov     a, 1                    ; Specify bank 1
    asr     a                       ; Store in carry flag
                                    ; Load bank 1 table:
    mov     A, >LoadConfigTBL_hspwmdp_Bank1
    mov     X, <LoadConfigTBL_hspwmdp_Bank1
    lcall   LoadConfig              ; Load the bank 1 values

	RAM_SETPAGE_CUR >ACTIVE_CONFIG_STATUS
; set config active bit
	or		[ACTIVE_CONFIG_STATUS+hspwmdp_ADDR_OFF], hspwmdp_BIT
    M8C_SetBank0                    ; Force return to bank 0
	pop		x

    RAM_EPILOGUE RAM_USE_CLASS_4
    ret

;---------------------------------------------------------------------------
; Reload Configuration hspwmdp
;
;    Reload configuration registers for hspwmdp.
;    IO Bank 0 registers a loaded first,then those in IO Bank 1.
;
;       INPUTS: None.
;      RETURNS: Nothing.
; SIDE EFFECTS: Registers are volatile: the CPU A and X registers may be
;               modified as may the Page Pointer registers!
;               In the large memory model currently only the page
;               pointer registers listed below are modified.  This does
;               not guarantee that in future implementations of this
;               function other page pointer registers will not be
;               modified.
;          
;               Page Pointer Registers Modified: 
;               CUR_PP
;
_ReloadConfig_hspwmdp:
 ReloadConfig_hspwmdp:
    RAM_PROLOGUE RAM_USE_CLASS_4

	push	x
    M8C_SetBank0                    ; Force bank 0
    mov     a, 0                    ; Specify bank 0
    asr     a                       ; Store in carry flag
                                    ; Bank 0 table address:
    mov     A, >ReloadConfigTBL_hspwmdp_Bank0
    mov     X, <ReloadConfigTBL_hspwmdp_Bank0
    lcall   LoadConfig              ; Reload the bank 0 values

    mov     a, 1                    ; Specify bank 1
    asr     a                       ; Store in carry flag
                                    ; Bank 1 table address:
    mov     A, >ReloadConfigTBL_hspwmdp_Bank1
    mov     X, <ReloadConfigTBL_hspwmdp_Bank1
    lcall   LoadConfig              ; Reload the bank 1 values

; set config active bit
	RAM_SETPAGE_CUR >ACTIVE_CONFIG_STATUS
	or		[ACTIVE_CONFIG_STATUS+hspwmdp_ADDR_OFF], hspwmdp_BIT
    M8C_SetBank0                    ; Force return to bank 0
	pop		x

    RAM_EPILOGUE RAM_USE_CLASS_4
    ret

;---------------------------------------------------------------------------
; Unload Configuration hspwmdp
;
;    Reset configuration registers for hspwmdp
;    to their values as initially configured.
;    IO Bank 0 registers a loaded first,then those in IO Bank 1.
;
;       INPUTS: None.
;      RETURNS: Nothing.
; SIDE EFFECTS: Registers are volatile: the CPU A and X registers may be
;               modified as may the Page Pointer registers!
;               In the large memory model currently only the page
;               pointer registers listed below are modified.  This does
;               not guarantee that in future implementations of this
;               function other page pointer registers will not be
;               modified.
;          
;               Page Pointer Registers Modified: 
;               CUR_PP
;
_UnloadConfig_hspwmdp:
 UnloadConfig_hspwmdp:
    RAM_PROLOGUE RAM_USE_CLASS_4

	push	x
    M8C_SetBank0                    ; Force bank 0
    mov     a, 0                    ; Specify bank 0
    asr     a                       ; Store in carry flag
                                    ; Bank 0 table address:
    mov     A, >UnloadConfigTBL_hspwmdp_Bank0
    mov     X, <UnloadConfigTBL_hspwmdp_Bank0
    lcall   LoadConfig              ; Unload the bank 0 values

    mov     a, 1                    ; Specify bank 1
    asr     a                       ; Store in carry flag
                                    ; Bank 1 table address:
    mov     A, >UnloadConfigTBL_hspwmdp_Bank1
    mov     X, <UnloadConfigTBL_hspwmdp_Bank1
    lcall   LoadConfig              ; Unload the bank 1 values

	M8C_SetBank1
	M8C_SetBank0
; clear config active bit
	RAM_SETPAGE_CUR >ACTIVE_CONFIG_STATUS
	and		[ACTIVE_CONFIG_STATUS+hspwmdp_ADDR_OFF], ~hspwmdp_BIT
    M8C_SetBank0                    ; Force return to bank 0
	pop		x

    RAM_EPILOGUE RAM_USE_CLASS_4
    ret

;---------------------------------------------------------------------------
; Load Configuration PRSPWM
;
;    Load configuration registers for PRSPWM.
;    IO Bank 0 registers a loaded first,then those in IO Bank 1.
;
;       INPUTS: None.
;      RETURNS: Nothing.
; SIDE EFFECTS: Registers are volatile: the CPU A and X registers may be
;               modified as may the Page Pointer registers!
;               In the large memory model currently only the page
;               pointer registers listed below are modified.  This does
;               not guarantee that in future implementations of this
;               function other page pointer registers will not be
;               modified.
;          
;               Page Pointer Registers Modified: 
;               CUR_PP
;
_LoadConfig_PRSPWM:
 LoadConfig_PRSPWM:
    RAM_PROLOGUE RAM_USE_CLASS_4
	M8C_SetBank1
; Saving POR level and disabling POR and LVD
	mov		a, reg[VLT_CR]
	push	a
	or		a, 30h
	and		a, f8h
	mov		reg[VLT_CR], a
; writing Port_0_DriveMode_0 register
	and		reg[ 0h], ~ 3h
	or		reg[ 0h],  3h
; writing Port_0_DriveMode_1 register
	and		reg[ 1h], ~ 3h
; writing Port_0_GlobalSelect register
	M8C_SetBank0
	and		reg[ 2h], ~ 3h
	or		reg[ 2h],  3h
; writing Port_2_DriveMode_0 register
	M8C_SetBank1
	and		reg[ 8h], ~85h
	or		reg[ 8h], 85h
; writing Port_2_DriveMode_1 register
	and		reg[ 9h], ~85h
; writing Port_2_DriveMode_2 register
	M8C_SetBank0
	and		reg[ bh], ~c5h
; writing Port_2_GlobalSelect register
	and		reg[ ah], ~c4h
	or		reg[ ah], c4h
; writing AnalogIOControl_0 register
	M8C_SetBank1
	and		reg[62h], ~58h
	or		reg[62h], 58h
; writing AnalogReferenceControl register
	M8C_SetBank0
	and		reg[63h], ~78h
	or		reg[63h], 70h
; writing GlobalDigitalInterconnect_Drive_Even_Output register
	M8C_SetBank1
	and		reg[d3h], ~28h
	or		reg[d3h], 28h
; writing GlobalDigitalInterconnect_Drive_Odd_Output register
	and		reg[d2h], ~1bh
	or		reg[d2h], 1bh
; writing OscillatorControl_3 register
	and		reg[dfh], ~ffh
; writing Row_0_LogicSelect_0 register
	M8C_SetBank0
	and		reg[b3h], ~ffh
	or		reg[b3h], 12h
; writing Row_0_LogicSelect_1 register
	and		reg[b4h], ~f0h
; writing Row_0_OutputDrive_0 register
	and		reg[b5h], ~24h
	or		reg[b5h], 24h
; writing Row_0_OutputDrive_1 register
	and		reg[b6h], ~10h
	or		reg[b6h], 10h
; writing Row_1_InputMux register
	and		reg[b8h], ~ 3h
	or		reg[b8h],  2h
; writing Row_1_LogicSelect_0 register
	and		reg[bbh], ~ fh
	or		reg[bbh],  7h
; writing Row_1_OutputDrive_0 register
	and		reg[bdh], ~ 1h
	or		reg[bdh],  1h
; writing Row_1_OutputDrive_1 register
	and		reg[beh], ~21h
	or		reg[beh], 21h
; writing Row_2_InputMux register
	and		reg[c0h], ~ffh
	or		reg[c0h], bfh
; writing Row_2_LogicSelect_0 register
	and		reg[c3h], ~ffh
	or		reg[c3h], 12h
; writing Row_2_LogicSelect_1 register
	and		reg[c4h], ~f0h
; writing Row_2_OutputDrive_0 register
	and		reg[c5h], ~48h
	or		reg[c5h], 48h
; writing Row_2_OutputDrive_1 register
	and		reg[c6h], ~40h
	or		reg[c6h], 40h
; writing Row_3_InputMux register
	and		reg[c8h], ~ fh
	or		reg[c8h],  bh
; writing Row_3_LogicSelect_0 register
	and		reg[cbh], ~f0h
	or		reg[cbh], 70h
; writing Row_3_OutputDrive_0 register
	and		reg[cdh], ~10h
	or		reg[cdh], 10h
	M8C_SetBank1
; Restoring POR and LVD level
	pop		a
	mov		reg[VLT_CR], a
	M8C_SetBank0

	push	x
    M8C_SetBank0                    ; Force bank 0
    mov     a, 0                    ; Specify bank 0
    asr     a                       ; Store in carry flag
                                    ; Load bank 0 table:
    mov     A, >LoadConfigTBL_PRSPWM_Bank0
    mov     X, <LoadConfigTBL_PRSPWM_Bank0
    lcall   LoadConfig              ; Load the bank 0 values

    mov     a, 1                    ; Specify bank 1
    asr     a                       ; Store in carry flag
                                    ; Load bank 1 table:
    mov     A, >LoadConfigTBL_PRSPWM_Bank1
    mov     X, <LoadConfigTBL_PRSPWM_Bank1
    lcall   LoadConfig              ; Load the bank 1 values

	RAM_SETPAGE_CUR >ACTIVE_CONFIG_STATUS
; set config active bit
	or		[ACTIVE_CONFIG_STATUS+PRSPWM_ADDR_OFF], PRSPWM_BIT
    M8C_SetBank0                    ; Force return to bank 0
	pop		x

    RAM_EPILOGUE RAM_USE_CLASS_4
    ret

;---------------------------------------------------------------------------
; Unload Configuration PRSPWM
;
;    Reset configuration registers for PRSPWM
;    to their values as initially configured.
;    IO Bank 0 registers a loaded first,then those in IO Bank 1.
;
;       INPUTS: None.
;      RETURNS: Nothing.
; SIDE EFFECTS: Registers are volatile: the CPU A and X registers may be
;               modified as may the Page Pointer registers!
;               In the large memory model currently only the page
;               pointer registers listed below are modified.  This does
;               not guarantee that in future implementations of this
;               function other page pointer registers will not be
;               modified.
;          
;               Page Pointer Registers Modified: 
;               CUR_PP
;
_UnloadConfig_PRSPWM:
 UnloadConfig_PRSPWM:
    RAM_PROLOGUE RAM_USE_CLASS_4

	push	x
    M8C_SetBank0                    ; Force bank 0
    mov     a, 0                    ; Specify bank 0
    asr     a                       ; Store in carry flag
                                    ; Bank 0 table address:
    mov     A, >UnloadConfigTBL_PRSPWM_Bank0
    mov     X, <UnloadConfigTBL_PRSPWM_Bank0
    lcall   LoadConfig              ; Unload the bank 0 values

    mov     a, 1                    ; Specify bank 1
    asr     a                       ; Store in carry flag
                                    ; Bank 1 table address:
    mov     A, >UnloadConfigTBL_PRSPWM_Bank1
    mov     X, <UnloadConfigTBL_PRSPWM_Bank1
    lcall   LoadConfig              ; Unload the bank 1 values

	M8C_SetBank1
; Saving POR level and disabling POR and LVD
	mov		a, reg[VLT_CR]
	push	a
	or		a, 30h
	and		a, f8h
	mov		reg[VLT_CR], a
; writing AnalogIOControl_0 register
	and		reg[62h], ~58h
; writing AnalogReferenceControl register
	M8C_SetBank0
	and		reg[63h], ~78h
; writing GlobalDigitalInterconnect_Drive_Even_Output register
	M8C_SetBank1
	and		reg[d3h], ~28h
; writing GlobalDigitalInterconnect_Drive_Odd_Output register
	and		reg[d2h], ~1bh
; writing OscillatorControl_3 register
	and		reg[dfh], ~ffh
	or		reg[dfh],  2h
; writing Row_0_LogicSelect_0 register
	M8C_SetBank0
	and		reg[b3h], ~ffh
	or		reg[b3h], 33h
; writing Row_0_LogicSelect_1 register
	and		reg[b4h], ~f0h
	or		reg[b4h], 30h
; writing Row_0_OutputDrive_0 register
	and		reg[b5h], ~24h
; writing Row_0_OutputDrive_1 register
	and		reg[b6h], ~10h
; writing Row_1_InputMux register
	and		reg[b8h], ~ 3h
	or		reg[b8h],  1h
; writing Row_1_LogicSelect_0 register
	and		reg[bbh], ~ fh
	or		reg[bbh],  3h
; writing Row_1_OutputDrive_0 register
	and		reg[bdh], ~ 1h
; writing Row_1_OutputDrive_1 register
	and		reg[beh], ~21h
; writing Row_2_InputMux register
	and		reg[c0h], ~ffh
; writing Row_2_LogicSelect_0 register
	and		reg[c3h], ~ffh
	or		reg[c3h], 33h
; writing Row_2_LogicSelect_1 register
	and		reg[c4h], ~f0h
	or		reg[c4h], 30h
; writing Row_2_OutputDrive_0 register
	and		reg[c5h], ~48h
; writing Row_2_OutputDrive_1 register
	and		reg[c6h], ~40h
; writing Row_3_InputMux register
	and		reg[c8h], ~ fh
	or		reg[c8h],  5h
; writing Row_3_LogicSelect_0 register
	and		reg[cbh], ~f0h
	or		reg[cbh], 30h
; writing Row_3_OutputDrive_0 register
	and		reg[cdh], ~10h
; writing Port_2_GlobalSelect register
	and		reg[ ah], ~c4h
; writing Port_2_DriveMode_2 register
	and		reg[ bh], ~c5h
	or		reg[ bh], c5h
; writing Port_2_DriveMode_1 register
	M8C_SetBank1
	and		reg[ 9h], ~85h
	or		reg[ 9h], 85h
; writing Port_2_DriveMode_0 register
	and		reg[ 8h], ~85h
; writing Port_0_GlobalSelect register
	M8C_SetBank0
	and		reg[ 2h], ~ 3h
; writing Port_0_DriveMode_1 register
	M8C_SetBank1
	and		reg[ 1h], ~ 3h
	or		reg[ 1h],  3h
; writing Port_0_DriveMode_0 register
	and		reg[ 0h], ~ 3h
	M8C_SetBank0
	M8C_SetBank1
; Restoring POR and LVD level
	pop		a
	mov		reg[VLT_CR], a
	M8C_SetBank0
; clear config active bit
	RAM_SETPAGE_CUR >ACTIVE_CONFIG_STATUS
	and		[ACTIVE_CONFIG_STATUS+PRSPWM_ADDR_OFF], ~PRSPWM_BIT
    M8C_SetBank0                    ; Force return to bank 0
	pop		x

    RAM_EPILOGUE RAM_USE_CLASS_4
    ret

;---------------------------------------------------------------------------
; Unload Configuration Total
;
;    Reset configuration registers for Total
;    to their values as initially configured.
;    IO Bank 0 registers a loaded first,then those in IO Bank 1.
;
;       INPUTS: None.
;      RETURNS: Nothing.
; SIDE EFFECTS: Registers are volatile: the CPU A and X registers may be
;               modified as may the Page Pointer registers!
;               In the large memory model currently only the page
;               pointer registers listed below are modified.  This does
;               not guarantee that in future implementations of this
;               function other page pointer registers will not be
;               modified.
;          
;               Page Pointer Registers Modified: 
;               CUR_PP
;
_UnloadConfig_Total:
 UnloadConfig_Total:
    RAM_PROLOGUE RAM_USE_CLASS_4

	push	x
    M8C_SetBank0                    ; Force bank 0
    mov     a, 0                    ; Specify bank 0
    asr     a                       ; Store in carry flag
                                    ; Bank 0 table address:
    mov     A, >UnloadConfigTBL_Total_Bank0
    mov     X, <UnloadConfigTBL_Total_Bank0
    lcall   LoadConfig              ; Unload the bank 0 values

    mov     a, 1                    ; Specify bank 1
    asr     a                       ; Store in carry flag
                                    ; Bank 1 table address:
    mov     A, >UnloadConfigTBL_Total_Bank1
    mov     X, <UnloadConfigTBL_Total_Bank1
    lcall   LoadConfig              ; Unload the bank 1 values

	M8C_SetBank1
	M8C_SetBank0
; clear config active bit
	RAM_SETPAGE_CUR >ACTIVE_CONFIG_STATUS
	mov		[ACTIVE_CONFIG_STATUS+0], 0
    M8C_SetBank0                    ; Force return to bank 0
	pop		x

    RAM_EPILOGUE RAM_USE_CLASS_4
    ret




;---------------------------------------------------------------------------
; LoadConfig - Set IO registers as specified in ROM table of (address,value)
;              pairs. Terminate on address=0xFF.
;
;  INPUTS:  [A,X] points to the table to be loaded
;           Flag Register Carry bit encodes the Register Bank
;           (Carry=0 => Bank 0; Carry=1 => Bank 1)
;
;  RETURNS: nothing.
;
;  STACK FRAME:  X-4 I/O Bank 0/1 indicator
;                X-3 Temporary store for register address
;                X-2 LSB of config table address
;                X-1 MSB of config table address
;
LoadConfig:
    RAM_PROLOGUE RAM_USE_CLASS_2
    add     SP, 2                   ; Set up local vars
    push    X                       ; Save config table address on stack
    push    A
    mov     X, SP
    mov     [X-4], 0                ; Set default Destination to Bank 0
    jnc     .BankSelectSaved        ; Carry says Bank 0 is OK
    mov     [X-4], 1                ; No Carry: default to Bank 1
.BankSelectSaved:
    pop     A
    pop     X

LoadConfigLp:
    M8C_SetBank0                    ; Switch to bank 0
    M8C_ClearWDT                    ; Clear the watchdog for long inits
    push    X                       ; Preserve the config table address
    push    A
    romx                            ; Load register address from table
    cmp     A, END_CONFIG_TABLE     ; End of table?
    jz      EndLoadConfig           ;   Yes, go wrap it up
    mov     X, SP                   ;
    tst     [X-4], 1                ; Loading IO Bank 1?
    jz      .IOBankNowSet           ;    No, Bank 0 is fine
    M8C_SetBank1                    ;   Yes, switch to Bank 1
.IOBankNowSet:
    mov     [X-3], A                ; Stash the register address
    pop     A                       ; Retrieve the table address
    pop     X
    inc     X                       ; Advance to the data byte
    adc     A, 0
    push    X                       ; Save the config table address again
    push    A
    romx                            ; load config data from the table
    mov     X, SP                   ; retrieve the register address
    mov     X, [X-3]
    mov     reg[X], A               ; Configure the register
    pop     A                       ; retrieve the table address
    pop     X
    inc     X                       ; advance to next table entry
    adc     A, 0
    jmp     LoadConfigLp            ; loop to configure another register
EndLoadConfig:
    add     SP, -4
    RAM_EPILOGUE RAM_USE_CLASS_2
    ret

AREA InterruptRAM(ram, rel)

NO_SHADOW:
_NO_SHADOW:
; active configuration status byte
ACTIVE_CONFIG_STATUS:	BLK	1

AREA text(rom, rel)
