;;*****************************************************************************
;;*****************************************************************************
;;  FILENAME: BUF2.inc
;;  Version: 1.3, Updated on 2010/4/6 at 11:27:6
;;  Generated by PSoC Designer 
;;
;;  DESCRIPTION: Assembler declarations for the Counter8 user module interface
;;-----------------------------------------------------------------------------
;;  Copyright (c) Cypress Semiconductor 2010. All Rights Reserved.
;;*****************************************************************************
;;*****************************************************************************

include "m8c.inc"


;--------------------------------------------------
; Constants for BUF2 API's.
;--------------------------------------------------

BUF2_CONTROL_REG_START_BIT:                equ 0x01    ; Control register start bit
BUF2_INT_REG:                              equ 0x0df
BUF2_INT_MASK:                             equ 0x10


;--------------------------------------------------
; Register Address Constants for BUF2
;--------------------------------------------------

BUF2_DATA_0_REG:                       equ 0x50   ; DR0 register
BUF2_DATA_1_REG:                       equ 0x51   ; DR1 register
BUF2_DATA_2_REG:                       equ 0x52   ; DR2 register
BUF2_CONTROL_REG:                      equ 0x53   ; Control register
BUF2_FUNC_REG:                         equ 0x50   ; Function register
BUF2_INPUT_REG:                        equ 0x51   ; Input register
BUF2_OUTPUT_REG:                       equ 0x52   ; Output register


;--------------------------------------------------
; BUF2 Macro 'Functions'
;--------------------------------------------------

   macro BUF2_Start_M
   or    reg[BUF2_CONTROL_REG],  BUF2_CONTROL_REG_START_BIT
   endm

   macro BUF2_Stop_M
   and   reg[BUF2_CONTROL_REG], ~BUF2_CONTROL_REG_START_BIT
   endm

   macro BUF2_EnableInt_M
   M8C_EnableIntMask BUF2_INT_REG, BUF2_INT_MASK
   endm

   macro BUF2_DisableInt_M
   M8C_DisableIntMask BUF2_INT_REG, BUF2_INT_MASK
   endm


; end of file BUF2.inc
