//*****************************************************************************
//*****************************************************************************
//  FILENAME: BUF2.h
//  Version: 1.3, Updated on 2010/4/6 at 11:27:6
//  Generated by PSoC Designer 
//
//  DESCRIPTION: DigitalBuffers User Module C Language interface file
//-----------------------------------------------------------------------------
//  Copyright (c) Cypress Semiconductor 2010. All Rights Reserved.
//*****************************************************************************
//*****************************************************************************
#ifndef BUF2_INCLUDE
#define BUF2_INCLUDE

#include <m8c.h>

#pragma fastcall16 BUF2_EnableInt
#pragma fastcall16 BUF2_DisableInt
#pragma fastcall16 BUF2_Start
#pragma fastcall16 BUF2_Stop

//-------------------------------------------------
// Prototypes of the BUF2 API.
//-------------------------------------------------

extern void BUF2_EnableInt(void);
extern void BUF2_DisableInt(void);
extern void BUF2_Start(void);
extern void BUF2_Stop(void);


//--------------------------------------------------
// Constants for BUF2 API's.
//--------------------------------------------------
#define BUF2_CONTROL_REG_START_BIT             ( 0x01 )
#define BUF2_INT_REG_ADDR                      ( 0x0df )
#define BUF2_INT_MASK                          ( 0x10 )


//--------------------------------------------------
// Constants for BUF2 user defined values
//--------------------------------------------------
#pragma ioport  BUF2_DATA_0_REG:    0x050                  //DR0 Count register
BYTE            BUF2_DATA_0_REG;
#pragma ioport  BUF2_DATA_1_REG:    0x051                  //DR1 Period register
BYTE            BUF2_DATA_1_REG;
#pragma ioport  BUF2_DATA_2_REG:    0x052                  //DR2 Compare register
BYTE            BUF2_DATA_2_REG;
#pragma ioport  BUF2_CONTROL_REG:   0x053                  //Control register
BYTE            BUF2_CONTROL_REG;
#pragma ioport  BUF2_FUNC_REG:  0x150                      //Function register
BYTE            BUF2_FUNC_REG;
#pragma ioport  BUF2_INPUT_REG: 0x151                      //Input register
BYTE            BUF2_INPUT_REG;
#pragma ioport  BUF2_OUTPUT_REG:    0x152                  //Output register
BYTE            BUF2_OUTPUT_REG;
#pragma ioport  BUF2_INT_REG:       0x0df                  //Interrupt Mask Register
BYTE            BUF2_INT_REG;


//-------------------------------------------------
// Register Addresses for BUF2
//-------------------------------------------------


//-------------------------------------------------
// BUF2 Macro 'Functions'
//-------------------------------------------------

#define BUF2_Start_M \
   BUF2_CONTROL_REG |=  BUF2_CONTROL_REG_START_BIT

#define BUF2_Stop_M  \
   BUF2_CONTROL_REG &= ~BUF2_CONTROL_REG_START_BIT

#define BUF2_EnableInt_M   \
   M8C_EnableIntMask(BUF2_INT_REG, BUF2_INT_MASK)

#define BUF2_DisableInt_M  \
   M8C_DisableIntMask(BUF2_INT_REG, BUF2_INT_MASK)

#endif
// end of file BUF2.h
