;;*****************************************************************************
;;*****************************************************************************
;;  FILENAME: BUF.inc
;;  Version: 1.3, Updated on 2010/4/6 at 11:27:6
;;  Generated by PSoC Designer 
;;
;;  DESCRIPTION: Assembler declarations for the Counter8 user module interface
;;-----------------------------------------------------------------------------
;;  Copyright (c) Cypress Semiconductor 2010. All Rights Reserved.
;;*****************************************************************************
;;*****************************************************************************

include "m8c.inc"


;--------------------------------------------------
; Constants for BUF API's.
;--------------------------------------------------

BUF_CONTROL_REG_START_BIT:                 equ 0x01    ; Control register start bit
BUF_INT_REG:                               equ 0x0e1
BUF_INT_MASK:                              equ 0x40


;--------------------------------------------------
; Register Address Constants for BUF
;--------------------------------------------------

BUF_DATA_0_REG:                        equ 0x38   ; DR0 register
BUF_DATA_1_REG:                        equ 0x39   ; DR1 register
BUF_DATA_2_REG:                        equ 0x3a   ; DR2 register
BUF_CONTROL_REG:                       equ 0x3b   ; Control register
BUF_FUNC_REG:                          equ 0x38   ; Function register
BUF_INPUT_REG:                         equ 0x39   ; Input register
BUF_OUTPUT_REG:                        equ 0x3a   ; Output register


;--------------------------------------------------
; BUF Macro 'Functions'
;--------------------------------------------------

   macro BUF_Start_M
   or    reg[BUF_CONTROL_REG],  BUF_CONTROL_REG_START_BIT
   endm

   macro BUF_Stop_M
   and   reg[BUF_CONTROL_REG], ~BUF_CONTROL_REG_START_BIT
   endm

   macro BUF_EnableInt_M
   M8C_EnableIntMask BUF_INT_REG, BUF_INT_MASK
   endm

   macro BUF_DisableInt_M
   M8C_DisableIntMask BUF_INT_REG, BUF_INT_MASK
   endm


; end of file BUF.inc
